/*
 * Decompiled with CFR 0.152.
 */
package com.BarrowsDoorHighlighter;

import com.BarrowsDoorHighlighter.BarrowsDoorHighlighter;
import com.BarrowsDoorHighlighter.BarrowsDoorHighlighterConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.ObjectComposition;
import net.runelite.api.WallObject;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

class BarrowsDoorHighlighterOverlay
extends Overlay {
    private final Client client;
    private final BarrowsDoorHighlighter plugin;
    private final BarrowsDoorHighlighterConfig config;

    @Inject
    private BarrowsDoorHighlighterOverlay(Client client, BarrowsDoorHighlighter plugin, BarrowsDoorHighlighterConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.UNDER_WIDGETS);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.client.getPlane() == 0 && this.config.highlightDoors() != BarrowsDoorHighlighterConfig.HighlightDoors.NEITHER) {
            this.renderDoors(graphics);
        }
        return null;
    }

    private void renderDoors(Graphics2D graphics) {
        for (WallObject door : this.plugin.getDoors()) {
            Shape polygon;
            Color color;
            ObjectComposition objectComp = this.client.getObjectDefinition(door.getId());
            ObjectComposition impostor = objectComp.getImpostorIds() != null ? objectComp.getImpostor() : null;
            if (impostor == null) continue;
            boolean isUnlockedDoor = impostor.getActions()[0] != null;
            Color color2 = color = isUnlockedDoor ? this.config.unlockedDoorColor() : this.config.lockedDoorColor();
            if ((this.config.highlightDoors() == BarrowsDoorHighlighterConfig.HighlightDoors.UNLOCKED || isUnlockedDoor) && (this.config.highlightDoors() == BarrowsDoorHighlighterConfig.HighlightDoors.LOCKED || !isUnlockedDoor) || (polygon = door.getConvexHull()) == null) continue;
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)polygon, (Color)color);
        }
    }
}

