/*
 * Decompiled with CFR 0.152.
 */
package com.BarrowsDoorHighlighter;

import com.BarrowsDoorHighlighter.BarrowsDoorHighlighterConfig;
import com.BarrowsDoorHighlighter.BarrowsDoorHighlighterOverlay;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.GameState;
import net.runelite.api.WallObject;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.WallObjectDespawned;
import net.runelite.api.events.WallObjectSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Barrows Door Highlighter")
public class BarrowsDoorHighlighter
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BarrowsDoorHighlighter.class);
    static final ImmutableSet<Integer> DOOR_IDS = ImmutableSet.of((Object)20681, (Object)20682, (Object)20683, (Object)20684, (Object)20685, (Object)20686, (Object[])new Integer[]{20687, 20688, 20689, 20690, 20691, 20692, 20693, 20694, 20695, 20696, 20700, 20701, 20702, 20703, 20704, 20705, 20706, 20707, 20708, 20709, 20710, 20711, 20712, 20713, 20714, 20715});
    private final Set<WallObject> doors = new HashSet<WallObject>();
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private BarrowsDoorHighlighterOverlay barrowsDoorHighlighterOverlay;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.barrowsDoorHighlighterOverlay);
    }

    protected void shutDown() throws Exception {
        this.doors.clear();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOADING) {
            this.doors.clear();
        }
    }

    @Provides
    BarrowsDoorHighlighterConfig provideConfig(ConfigManager configManager) {
        return (BarrowsDoorHighlighterConfig)configManager.getConfig(BarrowsDoorHighlighterConfig.class);
    }

    @Subscribe
    public void onWallObjectSpawned(WallObjectSpawned event) {
        WallObject wallObject = event.getWallObject();
        if (DOOR_IDS.contains((Object)wallObject.getId())) {
            this.doors.add(wallObject);
        }
    }

    @Subscribe
    public void onWallObjectDespawned(WallObjectDespawned event) {
        WallObject wallObject = event.getWallObject();
        this.doors.remove(wallObject);
    }

    public Set<WallObject> getDoors() {
        return this.doors;
    }
}

