/*
 * Decompiled with CFR 0.152.
 */
package com.shootingstartracking;

import java.util.EnumSet;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.World;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.WorldService;
import net.runelite.client.util.WorldUtil;
import net.runelite.http.api.worlds.WorldResult;

public class WorldHop {
    private static final int DISPLAY_SWITCHER_MAX_ATTEMPTS = 3;
    private final Client client;
    private final ClientThread clientThread;
    private final WorldService worldService;
    private final ChatMessageManager chatMessageManager;
    private World quickHopTargetWorld;
    private int displaySwitcherAttempts = 0;

    @Inject
    WorldHop(Client client, ClientThread clientThread, WorldService worldService, ChatMessageManager chatMessageManager) {
        this.client = client;
        this.clientThread = clientThread;
        this.worldService = worldService;
        this.chatMessageManager = chatMessageManager;
    }

    public void hop(int worldId) {
        WorldResult worldResult = this.worldService.getWorlds();
        if (worldResult == null) {
            return;
        }
        net.runelite.http.api.worlds.World world = worldResult.findWorld(worldId);
        if (world == null) {
            return;
        }
        this.clientThread.invoke(() -> this.hop(world));
    }

    private void hop(net.runelite.http.api.worlds.World world) {
        assert (this.client.isClientThread());
        World rsWorld = this.client.createWorld();
        rsWorld.setActivity(world.getActivity());
        rsWorld.setAddress(world.getAddress());
        rsWorld.setId(world.getId());
        rsWorld.setPlayerCount(world.getPlayers());
        rsWorld.setLocation(world.getLocation());
        rsWorld.setTypes(WorldUtil.toWorldTypes((EnumSet)world.getTypes()));
        if (this.client.getGameState() == GameState.LOGIN_SCREEN) {
            this.client.changeWorld(rsWorld);
            return;
        }
        this.quickHopTargetWorld = rsWorld;
        this.displaySwitcherAttempts = 0;
    }

    @Subscribe
    public void onGameTick() {
        if (this.quickHopTargetWorld == null) {
            return;
        }
        if (this.client.getWidget(WidgetInfo.WORLD_SWITCHER_LIST) == null) {
            this.client.openWorldHopper();
            if (++this.displaySwitcherAttempts >= 3) {
                String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Failed to quick-hop after ").append(ChatColorType.HIGHLIGHT).append(Integer.toString(this.displaySwitcherAttempts)).append(ChatColorType.NORMAL).append(" attempts.").build();
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
                this.resetQuickHopper();
            }
        } else {
            this.client.hopToWorld(this.quickHopTargetWorld);
            this.resetQuickHopper();
        }
    }

    private void resetQuickHopper() {
        this.displaySwitcherAttempts = 0;
        this.quickHopTargetWorld = null;
    }
}

