/*
 * Decompiled with CFR 0.152.
 */
package com.shootingstartracking;

import com.shootingstartracking.ShootingStarTrackingData;
import com.shootingstartracking.WorldHop;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;

public class ShootingStarTrackingTableRow
extends JPanel {
    private static final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("HH:mm");
    private static final ZoneId utcZoneId = ZoneId.of("UTC");
    private static final Color COLOR_NEGATIVE = new Color(255, 80, 80);
    private final ShootingStarTrackingData starData;
    private final boolean displayAsMinutes;
    private JLabel minTimeField;
    private JLabel maxTimeField;
    private JLabel locationField;

    ShootingStarTrackingTableRow(final ShootingStarTrackingData starData, boolean displayAsMinutes, final Color backgroundColor, final WorldHop worldHop, int curWorld) {
        this.starData = starData;
        this.displayAsMinutes = displayAsMinutes;
        this.setLayout(new BorderLayout());
        this.updateNotifyBorder();
        this.setBackground(backgroundColor);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ShootingStarTrackingTableRow.this.setBackground(ShootingStarTrackingTableRow.this.getBackground().brighter());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ShootingStarTrackingTableRow.this.setBackground(backgroundColor);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    worldHop.hop(starData.getWorld());
                }
            }
        });
        JPanel worldField = this.buildWorldField(curWorld);
        worldField.setPreferredSize(new Dimension(35, 20));
        worldField.setOpaque(false);
        JPanel locationField = this.buildLocationField();
        locationField.setToolTipText(starData.getLocation().getLocation());
        locationField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ShootingStarTrackingTableRow.this.setBackground(ShootingStarTrackingTableRow.this.getBackground().brighter());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ShootingStarTrackingTableRow.this.setBackground(backgroundColor);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    worldHop.hop(starData.getWorld());
                }
            }
        });
        locationField.setInheritsPopupMenu(true);
        this.setInheritsPopupMenu(true);
        locationField.setPreferredSize(new Dimension(60, 20));
        locationField.setOpaque(false);
        JPanel timeField = this.buildTimeField();
        timeField.setPreferredSize(new Dimension(94, 20));
        timeField.setOpaque(false);
        this.add((Component)worldField, "West");
        this.add((Component)locationField, "Center");
        this.add((Component)timeField, "East");
    }

    private JPanel buildWorldField(int world) {
        JPanel panel = new JPanel(new BorderLayout(7, 0));
        panel.setBorder(new EmptyBorder(0, 5, 0, 5));
        JLabel worldLabel = new JLabel(Integer.toString(this.starData.getWorld()));
        worldLabel.setFont(FontManager.getRunescapeSmallFont());
        worldLabel.setForeground(this.worldColor(world));
        panel.add((Component)worldLabel, "Center");
        return panel;
    }

    private Color worldColor(int curWorld) {
        if (this.starData.getWorld() == curWorld) {
            return ColorScheme.BRAND_ORANGE;
        }
        return ColorScheme.LIGHT_GRAY_COLOR;
    }

    private JPanel buildLocationField() {
        JPanel panel = new JPanel(new BorderLayout(7, 0));
        panel.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.locationField = new JLabel(this.starData.getLocation().getShortLocation());
        this.locationField.setFont(FontManager.getRunescapeSmallFont());
        this.updateLocationColor();
        panel.add((Component)this.locationField, "Center");
        return panel;
    }

    void updateLocationColor() {
        this.locationField.setForeground(this.getLocationColor());
    }

    private Color getLocationColor() {
        boolean maximumPassed;
        long time = ZonedDateTime.now(utcZoneId).toInstant().toEpochMilli();
        boolean minimumPassed = time > this.starData.getMinTime();
        boolean bl = maximumPassed = time > this.starData.getMaxTime();
        if (maximumPassed && minimumPassed) {
            return ColorScheme.PROGRESS_COMPLETE_COLOR;
        }
        if (minimumPassed) {
            return Color.YELLOW;
        }
        return ColorScheme.LIGHT_GRAY_COLOR;
    }

    private JPanel buildTimeField() {
        JPanel panel = new JPanel(new BorderLayout(7, 0));
        panel.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.minTimeField = new JLabel();
        this.minTimeField.setFont(FontManager.getRunescapeSmallFont());
        panel.add((Component)this.minTimeField, "Center");
        this.maxTimeField = new JLabel();
        this.maxTimeField.setFont(FontManager.getRunescapeSmallFont());
        panel.add((Component)this.maxTimeField, "East");
        this.updateTime();
        return panel;
    }

    void updateTime() {
        String maxTime;
        String minTime;
        if (this.displayAsMinutes) {
            minTime = ShootingStarTrackingTableRow.convertTime(this.starData.getMinTime());
            maxTime = ShootingStarTrackingTableRow.convertTime(this.starData.getMaxTime());
        } else {
            Instant minInstant = Instant.ofEpochMilli(this.starData.getMinTime());
            minTime = LocalDateTime.ofInstant(minInstant, ZoneId.systemDefault()).format(dtf);
            Instant maxInstant = Instant.ofEpochMilli(this.starData.getMaxTime());
            maxTime = LocalDateTime.ofInstant(maxInstant, ZoneId.systemDefault()).format(dtf);
        }
        this.minTimeField.setText(minTime);
        this.maxTimeField.setText(maxTime);
        this.minTimeField.setForeground(this.getTimeColor(this.starData.getMinTime()));
        this.maxTimeField.setForeground(this.getTimeColor(this.starData.getMaxTime()));
    }

    public static String convertTime(long epoch) {
        long seconds = TimeUnit.MILLISECONDS.toSeconds(epoch - Instant.now().toEpochMilli());
        boolean negative = seconds < 0L;
        seconds = Math.abs(seconds);
        Object time = negative ? "-" : "";
        long minutes = seconds / 60L;
        time = minutes >= 100L ? (String)time + minutes + "m" : (String)time + String.format("%d:%02d", minutes, seconds %= 60L);
        return time;
    }

    private Color getTimeColor(long time) {
        if (time > ZonedDateTime.now(utcZoneId).toInstant().toEpochMilli()) {
            return ColorScheme.LIGHT_GRAY_COLOR;
        }
        return COLOR_NEGATIVE;
    }

    public void updateNotifyBorder() {
        if (this.starData.isNotify()) {
            this.setBorder(new LineBorder(ColorScheme.BRAND_ORANGE, 1));
        } else {
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        }
    }

    public ShootingStarTrackingData getStarData() {
        return this.starData;
    }
}

