/*
 * Decompiled with CFR 0.152.
 */
package com.shootingstartracking;

import com.shootingstartracking.ShootingStarTrackingPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;

public class ShootingStarTrackingTableHeader
extends JPanel {
    private final JLabel textLabel = new JLabel();
    private final JLabel arrowLabel = new JLabel();
    private static final ImageIcon ARROW_UP;
    private static final ImageIcon HIGHLIGHT_ARROW_UP;
    private static final ImageIcon HIGHLIGHT_ARROW_DOWN;
    private boolean ordering = false;

    ShootingStarTrackingTableHeader(String title) {
        this.setLayout(new BorderLayout(5, 0));
        this.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, ColorScheme.LIGHT_GRAY_COLOR), new EmptyBorder(0, 5, 0, 2)));
        this.setBackground(ColorScheme.SCROLL_TRACK_COLOR);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!ShootingStarTrackingTableHeader.this.ordering) {
                    ShootingStarTrackingTableHeader.this.textLabel.setForeground(ColorScheme.BRAND_ORANGE);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!ShootingStarTrackingTableHeader.this.ordering) {
                    ShootingStarTrackingTableHeader.this.textLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
                }
            }
        });
        this.textLabel.setText(title);
        this.textLabel.setFont(FontManager.getRunescapeSmallFont());
        this.arrowLabel.setIcon(ARROW_UP);
        this.add((Component)this.textLabel, "West");
        this.add((Component)this.arrowLabel, "East");
    }

    void highlight(boolean on, boolean ascending) {
        this.ordering = on;
        this.arrowLabel.setIcon(on ? (ascending ? HIGHLIGHT_ARROW_DOWN : HIGHLIGHT_ARROW_UP) : ARROW_UP);
        this.textLabel.setForeground(on ? ColorScheme.BRAND_ORANGE : ColorScheme.LIGHT_GRAY_COLOR);
    }

    static {
        BufferedImage arrowDown = ImageUtil.loadImageResource(ShootingStarTrackingPlugin.class, (String)"/arrow.png");
        BufferedImage arrowUp = ImageUtil.rotateImage((BufferedImage)arrowDown, (double)Math.PI);
        ARROW_UP = new ImageIcon(arrowUp);
        BufferedImage highlightArrowDown = ImageUtil.fillImage((BufferedImage)arrowDown, (Color)ColorScheme.BRAND_ORANGE);
        BufferedImage highlightArrowUp = ImageUtil.fillImage((BufferedImage)arrowUp, (Color)ColorScheme.BRAND_ORANGE);
        HIGHLIGHT_ARROW_DOWN = new ImageIcon(highlightArrowDown);
        HIGHLIGHT_ARROW_UP = new ImageIcon(highlightArrowUp);
    }
}

