/*
 * Decompiled with CFR 0.152.
 */
package com.shootingstartracking;

import com.google.common.collect.Ordering;
import com.shootingstartracking.ShootingStarTrackingData;
import com.shootingstartracking.ShootingStarTrackingPlugin;
import com.shootingstartracking.ShootingStarTrackingTableHeader;
import com.shootingstartracking.ShootingStarTrackingTableRow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.function.Function;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;

public class ShootingStarTrackingPanel
extends PluginPanel {
    private static final ZoneId utcZoneId = ZoneId.of("UTC");
    private static final String ADD_NOTIFICATION = "Add notification";
    private static final String REMOVE_NOTIFICATION = "Remove notification";
    static final int WORLD_WIDTH = 35;
    static final int LOCATION_WIDTH = 60;
    static final int TIME_WIDTH = 47;
    private ShootingStarTrackingTableHeader worldHeader;
    private ShootingStarTrackingTableHeader locationHeader;
    private ShootingStarTrackingTableHeader minTimeHeader;
    private ShootingStarTrackingTableHeader maxTimeHeader;
    private final JPanel listContainer = new JPanel();
    private final ShootingStarTrackingPlugin plugin;
    private Order orderIndex = Order.MIN_TIME;
    private boolean ascendingOrder = false;

    ShootingStarTrackingPanel(ShootingStarTrackingPlugin plugin) {
        this.plugin = plugin;
        this.setBorder(null);
        this.setLayout((LayoutManager)new DynamicGridLayout(0, 1));
        JPanel header = this.buildHeader();
        this.listContainer.setLayout(new GridLayout(0, 1));
        this.add(header);
        this.add(this.listContainer);
        JPanel buttons = new JPanel();
        buttons.setBorder(new EmptyBorder(5, 5, 5, 5));
        buttons.setLayout(new BoxLayout(buttons, 1));
        buttons.add(this.importPanel());
        buttons.add(Box.createRigidArea(new Dimension(0, 5)));
        buttons.add(this.exportPanel());
        buttons.add(Box.createRigidArea(new Dimension(0, 5)));
        buttons.add(this.discordPanel());
        buttons.add(Box.createRigidArea(new Dimension(0, 5)));
        buttons.add(this.removePanel());
        this.add(buttons);
    }

    private JPanel buildHeader() {
        JPanel header = new JPanel(new BorderLayout());
        this.worldHeader = new ShootingStarTrackingTableHeader("W");
        this.worldHeader.setPreferredSize(new Dimension(35, 20));
        this.worldHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                ShootingStarTrackingPanel.this.ascendingOrder = ShootingStarTrackingPanel.this.orderIndex != Order.WORLD || !ShootingStarTrackingPanel.this.ascendingOrder;
                ShootingStarTrackingPanel.this.orderBy(Order.WORLD);
            }
        });
        this.locationHeader = new ShootingStarTrackingTableHeader("Location");
        this.locationHeader.setPreferredSize(new Dimension(60, 20));
        this.locationHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                ShootingStarTrackingPanel.this.ascendingOrder = ShootingStarTrackingPanel.this.orderIndex != Order.LOCATION || !ShootingStarTrackingPanel.this.ascendingOrder;
                ShootingStarTrackingPanel.this.orderBy(Order.LOCATION);
            }
        });
        JPanel timePanel = new JPanel(new BorderLayout());
        this.minTimeHeader = new ShootingStarTrackingTableHeader("Min");
        this.minTimeHeader.setPreferredSize(new Dimension(47, 20));
        this.minTimeHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                ShootingStarTrackingPanel.this.ascendingOrder = ShootingStarTrackingPanel.this.orderIndex != Order.MIN_TIME || !ShootingStarTrackingPanel.this.ascendingOrder;
                ShootingStarTrackingPanel.this.orderBy(Order.MIN_TIME);
            }
        });
        this.minTimeHeader.highlight(true, this.ascendingOrder);
        this.maxTimeHeader = new ShootingStarTrackingTableHeader("Max");
        this.maxTimeHeader.setPreferredSize(new Dimension(47, 20));
        this.maxTimeHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                ShootingStarTrackingPanel.this.ascendingOrder = ShootingStarTrackingPanel.this.orderIndex != Order.MAX_TIME || !ShootingStarTrackingPanel.this.ascendingOrder;
                ShootingStarTrackingPanel.this.orderBy(Order.MAX_TIME);
            }
        });
        timePanel.add((Component)this.minTimeHeader, "West");
        timePanel.add((Component)this.maxTimeHeader, "East");
        header.add((Component)this.worldHeader, "West");
        header.add((Component)this.locationHeader, "Center");
        header.add((Component)timePanel, "East");
        return header;
    }

    void updateList(List<ShootingStarTrackingData> starData) {
        this.listContainer.removeAll();
        if (starData.isEmpty()) {
            JLabel noStarsLabel = new JLabel("Look through a telescope to start tracking stars");
            noStarsLabel.setFont(FontManager.getRunescapeSmallFont());
            noStarsLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.listContainer.add(noStarsLabel);
        } else {
            starData.sort((r1, r2) -> {
                switch (this.orderIndex) {
                    case WORLD: {
                        return this.getCompareValue((ShootingStarTrackingData)r1, (ShootingStarTrackingData)r2, ShootingStarTrackingData::getWorld);
                    }
                    case LOCATION: {
                        return this.getCompareValue((ShootingStarTrackingData)r1, (ShootingStarTrackingData)r2, row -> row.getLocation().getLocation());
                    }
                    case MIN_TIME: {
                        return this.getCompareValue((ShootingStarTrackingData)r1, (ShootingStarTrackingData)r2, ShootingStarTrackingData::getMinTime);
                    }
                    case MAX_TIME: {
                        return this.getCompareValue((ShootingStarTrackingData)r1, (ShootingStarTrackingData)r2, ShootingStarTrackingData::getMaxTime);
                    }
                }
                return 0;
            });
            int i = 0;
            for (ShootingStarTrackingData data : starData) {
                Color backgroundColor = i % 2 == 0 ? ColorScheme.DARK_GRAY_COLOR : ColorScheme.DARKER_GRAY_COLOR;
                ShootingStarTrackingTableRow r = new ShootingStarTrackingTableRow(data, this.plugin.isDisplayAsMinutes(), backgroundColor, this.plugin.getWorldHop(), this.plugin.getWorld());
                r.setComponentPopupMenu(this.buildRemoveMenu(r, data));
                this.listContainer.add(r);
                ++i;
            }
        }
        this.listContainer.revalidate();
        this.listContainer.repaint();
    }

    public void updateTimes(List<ShootingStarTrackingData> starData) {
        if (starData.isEmpty()) {
            return;
        }
        for (Component component : this.listContainer.getComponents()) {
            ShootingStarTrackingTableRow r = (ShootingStarTrackingTableRow)component;
            r.updateTime();
            r.updateLocationColor();
        }
        this.listContainer.repaint();
    }

    private JPopupMenu buildRemoveMenu(ShootingStarTrackingTableRow row, ShootingStarTrackingData star) {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        JMenuItem hopEntryOption = new JMenuItem();
        hopEntryOption.setText("Hop to");
        hopEntryOption.setFont(FontManager.getRunescapeSmallFont());
        hopEntryOption.addActionListener(e -> this.plugin.hopTo(star));
        popupMenu.add(hopEntryOption);
        JMenuItem removeEntryOption = new JMenuItem();
        removeEntryOption.setText("Remove");
        removeEntryOption.setFont(FontManager.getRunescapeSmallFont());
        removeEntryOption.addActionListener(e -> this.plugin.removeStar(star));
        popupMenu.add(removeEntryOption);
        if (ZonedDateTime.now(utcZoneId).toInstant().toEpochMilli() < star.getMaxTime()) {
            JMenuItem notifyOption = new JMenuItem();
            if (star.isNotify()) {
                notifyOption.setText(REMOVE_NOTIFICATION);
            } else {
                notifyOption.setText(ADD_NOTIFICATION);
            }
            notifyOption.setFont(FontManager.getRunescapeSmallFont());
            notifyOption.addActionListener(e -> {
                if (star.isNotify()) {
                    notifyOption.setText(ADD_NOTIFICATION);
                } else {
                    notifyOption.setText(REMOVE_NOTIFICATION);
                }
                star.setNotify(!star.isNotify());
                row.updateNotifyBorder();
                notifyOption.repaint();
            });
            popupMenu.add(notifyOption);
        }
        return popupMenu;
    }

    private int getCompareValue(ShootingStarTrackingData row1, ShootingStarTrackingData row2, Function<ShootingStarTrackingData, Comparable> compareFn) {
        Ordering ordering = Ordering.natural();
        if (!this.ascendingOrder) {
            ordering = ordering.reverse();
        }
        ordering = ordering.reverse();
        return ordering.compare((Object)compareFn.apply(row1), (Object)compareFn.apply(row2));
    }

    private void orderBy(Order order) {
        this.worldHeader.highlight(false, this.ascendingOrder);
        this.locationHeader.highlight(false, this.ascendingOrder);
        this.minTimeHeader.highlight(false, this.ascendingOrder);
        this.maxTimeHeader.highlight(false, this.ascendingOrder);
        switch (order) {
            case WORLD: {
                this.worldHeader.highlight(true, this.ascendingOrder);
                break;
            }
            case LOCATION: {
                this.locationHeader.highlight(true, this.ascendingOrder);
                break;
            }
            case MIN_TIME: {
                this.minTimeHeader.highlight(true, this.ascendingOrder);
                break;
            }
            case MAX_TIME: {
                this.maxTimeHeader.highlight(true, this.ascendingOrder);
            }
        }
        this.orderIndex = order;
        this.updateList(this.plugin.getStarData());
    }

    private JPanel exportPanel() {
        final JPanel panel = new JPanel();
        JLabel label = new JLabel("Export");
        panel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        panel.setPreferredSize(new Dimension(60, 30));
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isRightMouseButton(e)) {
                    ShootingStarTrackingPanel.this.plugin.exportData();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                panel.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                panel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            }
        });
        panel.add(label);
        return panel;
    }

    private JPanel importPanel() {
        final JPanel panel = new JPanel();
        JLabel label = new JLabel("Import");
        panel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        panel.setPreferredSize(new Dimension(60, 30));
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isRightMouseButton(e)) {
                    ShootingStarTrackingPanel.this.plugin.importData();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                panel.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                panel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            }
        });
        panel.add(label);
        return panel;
    }

    private JPanel discordPanel() {
        final JPanel panel = new JPanel();
        JLabel label = new JLabel("Copy for Discord format");
        panel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        panel.setPreferredSize(new Dimension(60, 30));
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isRightMouseButton(e)) {
                    ShootingStarTrackingPanel.this.plugin.discordFormat();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                panel.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                panel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            }
        });
        panel.add(label);
        return panel;
    }

    private JPanel removePanel() {
        final JPanel panel = new JPanel();
        JLabel label = new JLabel("Remove clipboard worlds");
        panel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        panel.setPreferredSize(new Dimension(60, 30));
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isRightMouseButton(e)) {
                    ShootingStarTrackingPanel.this.plugin.removeWorldsInClipboard();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                panel.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                panel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            }
        });
        panel.add(label);
        return panel;
    }

    private static enum Order {
        WORLD,
        LOCATION,
        MIN_TIME,
        MAX_TIME;

    }
}

