/*
 * Decompiled with CFR 0.152.
 */
package com.shootingstartracking;

public class ShootingStarTrackingData {
    private final int world;
    private final ShootingStarLocations location;
    private final long minTime;
    private final long maxTime;
    private transient boolean notify;

    public ShootingStarTrackingData(int world, ShootingStarLocations location, long minTime, long maxTime) {
        this.world = world;
        this.location = location;
        this.minTime = minTime;
        this.maxTime = maxTime;
    }

    public String toString() {
        return "world:" + this.world + " location:" + this.location + " time:" + this.minTime + " - " + this.maxTime;
    }

    public int getWorld() {
        return this.world;
    }

    public ShootingStarLocations getLocation() {
        return this.location;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
    }

    static enum ShootingStarLocations {
        ASGARNIA("Asgarnia"),
        KARAMJA("Crandor or Karamja", "Crandor / Karamja"),
        FELDIP_HILLS("Feldip Hills or on the Isle of Souls", "Feldip Hills / Isle of Souls"),
        FOSSIL_ISLAND("Fossil Island or on Mos Le'Harmless", "Fossil Island / Mos Le'Harmless"),
        FREMENNIK("Fremennik Lands or on Lunar Isle", "Fremennik Lands / Lunar Isle"),
        KOUREND("Great Kourend"),
        KANDARIN("Kandarin"),
        KEBOS("Kebos Lowlands"),
        KHARIDIAN_DESERT("Kharidian Desert"),
        MISTHALIN("Misthalin"),
        MORYTANIA("Morytania"),
        PISCATORIS("Piscatoris or the Gnome Stronghold", "Piscatoris / Gnome Stronghold"),
        TIRANNWN("Tirannwn"),
        WILDERNESS("Wilderness"),
        UNKNOWN("Unknown");

        public static final ShootingStarLocations[] values;
        private final String location;
        private final String shortLocation;

        private ShootingStarLocations(String location, String shortLocation) {
            this.location = location;
            this.shortLocation = shortLocation;
        }

        private ShootingStarLocations(String location) {
            this(location, location);
        }

        public String getLocation() {
            return this.location;
        }

        public String getShortLocation() {
            return this.shortLocation;
        }

        static {
            values = ShootingStarLocations.values();
        }
    }
}

