/*
 * Decompiled with CFR 0.152.
 */
package com.polywoof;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.polywoof.PolywoofFormatter;
import com.polywoof.PolywoofPlugin;
import com.polywoof.PolywoofStorage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.runelite.client.RuneLite;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class PolywoofTranslator {
    private static final Logger log = LoggerFactory.getLogger(PolywoofTranslator.class);
    private static final JsonParser parser = new JsonParser();
    private static final List<PolywoofStorage.Language> trusted = new ArrayList<PolywoofStorage.Language>(100);
    private static final List<PolywoofStorage.Language> offline = PolywoofTranslator.languageLoader(PolywoofPlugin.class, "/languages.json");
    private final OkHttpClient client;
    private final PolywoofStorage storage;
    private String URL;
    private String key;

    public PolywoofTranslator(OkHttpClient client, PolywoofStorage storage, String auth) {
        this.client = client;
        this.storage = storage;
        this.update(auth);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static synchronized List<PolywoofStorage.Language> languageLoader(Class<?> reflection, String resource) {
        try (InputStream stream = reflection.getResourceAsStream(resource);){
            ArrayList<OfflineLanguage> arrayList;
            if (stream == null) {
                throw new IllegalArgumentException();
            }
            try (InputStreamReader reader = new InputStreamReader(stream);){
                JsonArray json = parser.parse((Reader)reader).getAsJsonArray();
                ArrayList<OfflineLanguage> output = new ArrayList<OfflineLanguage>(json.size());
                for (JsonElement element : json) {
                    output.add(new OfflineLanguage(element.getAsJsonObject().get("language").getAsString(), element.getAsJsonObject().get("name").getAsString()));
                }
                arrayList = output;
            }
            return arrayList;
        }
        catch (IOException error) {
            log.error("Failed to load languages from the resource", (Throwable)error);
            return new ArrayList<PolywoofStorage.Language>(0);
        }
    }

    public static PolywoofStorage.Language languageFinder(String search) {
        search = search.trim().toUpperCase();
        for (PolywoofStorage.Language language : trusted) {
            if (!language.toString().toUpperCase().equals(search)) continue;
            return language;
        }
        for (PolywoofStorage.Language language : offline) {
            if (!language.toString().toUpperCase().equals(search)) continue;
            return language;
        }
        for (PolywoofStorage.Language language : trusted) {
            if (!language.name.toUpperCase().startsWith(search)) continue;
            return language;
        }
        for (PolywoofStorage.Language language : offline) {
            if (!language.name.toUpperCase().startsWith(search)) continue;
            return language;
        }
        for (PolywoofStorage.Language language : trusted) {
            if (!language.name.toUpperCase().contains(search)) continue;
            return language;
        }
        for (PolywoofStorage.Language language : offline) {
            if (!language.name.toUpperCase().contains(search)) continue;
            return language;
        }
        return new UnknownLanguage(search);
    }

    private static void handleCode(int code) throws Exception {
        switch (code) {
            case 200: {
                return;
            }
            case 400: {
                throw new Exception("Bad request");
            }
            case 403: {
                throw new Exception("Authorization failed");
            }
            case 404: {
                throw new Exception("The requested resource could not be found");
            }
            case 413: {
                throw new Exception("The request size exceeds the limit");
            }
            case 414: {
                throw new Exception("The request URL is too long");
            }
            case 429: {
                throw new Exception("Too many requests");
            }
            case 456: {
                throw new Exception("Quota exceeded");
            }
            case 503: {
                throw new Exception("Resource currently unavailable");
            }
        }
        throw new Exception("Internal error");
    }

    private void post(String path, RequestBody request, final Receivable callback) {
        if (this.key.isEmpty()) {
            return;
        }
        try {
            Request headers = new Request.Builder().addHeader("User-Agent", RuneLite.USER_AGENT + " (polywoof)").addHeader("Authorization", "DeepL-Auth-Key " + this.key).addHeader("Accept", "application/json").addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Content-Length", String.valueOf(request.contentLength())).url(this.URL + path).post(request).build();
            this.client.newCall(headers).enqueue(new Callback(){

                public void onFailure(Call call, IOException error) {
                    log.error("Failed to receive the API response", (Throwable)error);
                }

                public void onResponse(Call call, Response response) {
                    try (ResponseBody body = response.body();){
                        PolywoofTranslator.handleCode(response.code());
                        if (body == null) {
                            return;
                        }
                        callback.receive(body.string());
                    }
                    catch (Exception error) {
                        log.error("Failed to proceed the API response", (Throwable)error);
                    }
                }
            });
        }
        catch (IOException error) {
            log.error("Failed to create the API request", (Throwable)error);
        }
    }

    public void translate(String string, PolywoofStorage.Language language, PolywoofStorage.DataType type, Translatable callback) {
        if (string.isEmpty() || language instanceof UnknownLanguage) {
            return;
        }
        if (!this.storage.status()) {
            this.translate(string, language, callback);
            return;
        }
        this.storage.select(string, language, type, select -> {
            if (select == null) {
                this.translate(string, language, insert -> {
                    this.storage.insert(insert, string, language, type, () -> log.debug("[{}] INSERT", (Object)language));
                    callback.translate(insert);
                });
            } else {
                log.debug("[{}] SELECT", (Object)language);
                callback.translate(select);
            }
        });
    }

    public void translate(String string, PolywoofStorage.Language language, Translatable callback) {
        if ((string = PolywoofFormatter.filter(string)).isEmpty() || !(language instanceof TrustedLanguage)) {
            return;
        }
        FormBody.Builder request = new FormBody.Builder().add("target_lang", language.toString()).add("source_lang", "en").add("preserve_formatting", "1").add("tag_handling", "html").add("non_splitting_tags", "br");
        for (String split : string.split("\n")) {
            request.add("text", split);
        }
        this.post("/v2/translate", (RequestBody)request.build(), body -> {
            JsonObject json = parser.parse(body).getAsJsonObject();
            StringBuilder output = new StringBuilder(128);
            for (JsonElement element : json.getAsJsonArray("translations")) {
                output.append(StringEscapeUtils.unescapeHtml4((String)element.getAsJsonObject().get("text").getAsString())).append("\n");
            }
            callback.translate(output.toString());
        });
    }

    public void usage(Usable callback) {
        this.post("/v2/usage", (RequestBody)new FormBody.Builder().build(), body -> {
            JsonObject json = parser.parse(body).getAsJsonObject();
            callback.usage(json.get("character_count").getAsLong(), json.get("character_limit").getAsLong());
        });
    }

    public void languages(String type, Supportable callback) {
        this.post("/v2/languages", (RequestBody)new FormBody.Builder().add("type", type).build(), body -> {
            JsonArray json = parser.parse(body).getAsJsonArray();
            List<PolywoofStorage.Language> list = trusted;
            synchronized (list) {
                trusted.clear();
                for (JsonElement element : json) {
                    trusted.add(new TrustedLanguage(element.getAsJsonObject()));
                }
                callback.list(trusted);
            }
        });
    }

    public void update(String auth) {
        this.URL = auth.endsWith(":fx") ? "https://api-free.deepl.com" : "https://api.deepl.com";
        this.key = auth;
    }

    public static class UnknownLanguage
    extends PolywoofStorage.Language {
        public UnknownLanguage(String code) {
            super(code, "Unknown");
        }
    }

    public static class OfflineLanguage
    extends PolywoofStorage.Language {
        public OfflineLanguage(String code, String name) {
            super(code, name);
        }
    }

    public static class TrustedLanguage
    extends PolywoofStorage.Language {
        public TrustedLanguage(JsonObject object) {
            super(object.get("language").getAsString(), object.get("name").getAsString());
        }
    }

    public static interface Supportable {
        public void list(List<PolywoofStorage.Language> var1);
    }

    public static interface Usable {
        public void usage(long var1, long var3);
    }

    public static interface Translatable {
        public void translate(String var1);
    }

    public static interface Receivable {
        public void receive(String var1) throws Exception;
    }
}

