/*
 * Decompiled with CFR 0.152.
 */
package com.polywoof;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.h2.jdbcx.JdbcDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class PolywoofStorage
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(PolywoofStorage.class);
    private final Executor executor = Executors.newSingleThreadExecutor();
    private final JdbcDataSource data = new JdbcDataSource();
    private Connection db;

    public PolywoofStorage(File file) {
        String path = file.getPath();
        if (path.endsWith(".mv.db")) {
            path = path.substring(0, path.length() - ".mv.db".length());
        }
        this.data.setURL("jdbc:h2:" + path);
    }

    public void open() {
        if (this.status()) {
            return;
        }
        this.executor.execute(() -> {
            try {
                Connection connection = this.data.getConnection();
                for (DataType type : DataType.values()) {
                    try (PreparedStatement create = connection.prepareStatement(String.format("CREATE TABLE IF NOT EXISTS `%1$s` (OSRS VARCHAR(%2$s) PRIMARY KEY)", new Object[]{type, type.size}));){
                        create.executeUpdate();
                    }
                    catch (SQLException error) {
                        log.error("Failed to prepare the database", (Throwable)error);
                        connection.close();
                        return;
                    }
                }
                this.db = connection;
            }
            catch (SQLException error) {
                log.error("Failed to open the database", (Throwable)error);
            }
        });
    }

    @Override
    public void close() {
        if (!this.status()) {
            return;
        }
        this.executor.execute(() -> {
            try {
                this.db.close();
            }
            catch (SQLException error) {
                log.error("Failed to close the database", (Throwable)error);
            }
        });
    }

    public void select(String key, Language column, DataType table, @Nullable Selectable callback) {
        if (!this.status()) {
            return;
        }
        this.executor.execute(() -> {
            try (PreparedStatement schema = this.db.prepareStatement("SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME=? AND COLUMN_NAME=?");){
                schema.setString(1, table.toString());
                schema.setString(2, column.toString());
                if (!schema.executeQuery().next()) {
                    if (callback != null) {
                        callback.select(null);
                    }
                    return;
                }
                try (PreparedStatement select = this.db.prepareStatement(String.format("SELECT `%2$s` FROM `%1$s` WHERE OSRS=? AND `%2$s` IS NOT NULL", new Object[]{table, column}));){
                    select.setString(1, key);
                    ResultSet result = select.executeQuery();
                    String string = null;
                    if (result.next()) {
                        string = result.getString(column.toString());
                    }
                    if (callback != null) {
                        callback.select(string);
                    }
                }
            }
            catch (SQLException error) {
                log.error("Failed to select from the database", (Throwable)error);
            }
        });
    }

    public void insert(String string, String key, Language column, DataType table, @Nullable Insertable callback) {
        if (!this.status()) {
            return;
        }
        this.executor.execute(() -> {
            try (PreparedStatement update = this.db.prepareStatement(String.format("ALTER TABLE `%1$s` ADD IF NOT EXISTS `%3$s` VARCHAR(%2$s)", new Object[]{table, table.size, column}));){
                update.executeUpdate();
                try (PreparedStatement insert = this.db.prepareStatement(String.format("MERGE INTO `%1$s` (OSRS, `%2$s`) VALUES(?, ?)", new Object[]{table, column}));){
                    insert.setString(1, key);
                    insert.setString(2, string);
                    insert.executeUpdate();
                    if (callback != null) {
                        callback.insert();
                    }
                }
            }
            catch (SQLException error) {
                log.error("Failed to insert into the database", (Throwable)error);
            }
        });
    }

    public boolean status() {
        try {
            return this.db != null && !this.db.isClosed();
        }
        catch (SQLException error) {
            log.error("Failed to check the database", (Throwable)error);
            return false;
        }
    }

    public static class Language {
        public final String code;
        public final String name;

        public String toString() {
            return this.code;
        }

        protected Language(String code, String name) {
            this.code = code;
            this.name = name;
        }
    }

    static interface Insertable {
        public void insert();
    }

    static interface Selectable {
        public void select(@Nullable String var1);
    }

    public static enum DataType {
        CHAT_MESSAGES(256),
        ANY_EXAMINE(256),
        OVERHEAD_TEXT(256),
        DIALOGUE_TEXT(512),
        DIALOGUE_OPTIONS(512),
        VARIOUS_SCROLLS(1024),
        VARIOUS_BOOKS(2048),
        QUEST_DIARY(2048);

        public final int size;

        public String toString() {
            return this.name();
        }

        private DataType(int size) {
            this.size = size;
        }
    }
}

