/*
 * Decompiled with CFR 0.152.
 */
package com.polywoof;

import com.google.inject.Provides;
import com.polywoof.PolywoofComponent;
import com.polywoof.PolywoofConfig;
import com.polywoof.PolywoofFormatter;
import com.polywoof.PolywoofOverlay;
import com.polywoof.PolywoofStorage;
import com.polywoof.PolywoofTranslator;
import java.awt.Color;
import java.io.File;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.NPC;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.OverheadTextChanged;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.RuneLite;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.util.ColorUtil;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@PluginDescriptor(name="Polywoof", description="Translation for almost every dialogue and some related text, so you can understand what's going on!", tags={"helper", "language", "translator", "translation"})
public class PolywoofPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PolywoofPlugin.class);
    private PolywoofStorage storage;
    private PolywoofTranslator translator;
    private Widget[] widgets;
    private int dialogue;
    private String previous;
    @Inject
    private Client client;
    @Inject
    private PolywoofConfig config;
    @Inject
    private PolywoofOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private OkHttpClient okHttpClient;

    @Provides
    PolywoofConfig provideConfig(ConfigManager configManager) {
        return (PolywoofConfig)configManager.getConfig(PolywoofConfig.class);
    }

    protected void startUp() throws Exception {
        this.storage = new PolywoofStorage(new File(RuneLite.CACHE_DIR, "polywoof.mv.db"));
        this.storage.open();
        this.translator = new PolywoofTranslator(this.okHttpClient, this.storage, this.config.key());
        this.translator.languages("target", languages -> log.info("{} languages loaded!", (Object)languages.size()));
        this.overlay.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.overlay.setPriority(OverlayPriority.LOW);
        this.overlay.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.overlay.revalidate();
        this.overlayManager.add((Overlay)this.overlay);
        if (this.config.key().isEmpty()) {
            String message = new ChatMessageBuilder().append("Polywoof is not ready, the ").append(ChatColorType.HIGHLIGHT).append("API Key").append(ChatColorType.NORMAL).append(" is missing.").build();
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
        }
        if (this.config.showUsage()) {
            this.showUsage();
        }
    }

    protected void shutDown() throws Exception {
        this.storage.close();
        this.overlay.reset();
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("polywoof")) {
            return;
        }
        switch (event.getKey()) {
            case "language": {
                if (!(PolywoofTranslator.languageFinder(this.config.language()) instanceof PolywoofTranslator.UnknownLanguage)) break;
                Object language = this.config.language().trim().replaceAll("\n", " ");
                if (((String)language).length() > 10) {
                    language = ((String)language).substring(0, 10) + "...";
                }
                String message = new ChatMessageBuilder().append("Your chosen language \u00ab").append(ChatColorType.HIGHLIGHT).append((String)language).append(ChatColorType.NORMAL).append("\u00bb is not found!").build();
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
                break;
            }
            case "key": {
                this.translator.update(this.config.key());
                this.translator.languages("target", languages -> log.info("{} languages loaded!", (Object)languages.size()));
                break;
            }
            case "showButton": {
                this.config.toggle(true);
                break;
            }
            case "fontName": 
            case "fontSize": 
            case "textShadow": 
            case "overlayColor": 
            case "overlayOutline": 
            case "textAlignment": 
            case "textWrap": 
            case "sourceName": 
            case "numberedOptions": {
                this.overlay.revalidate();
            }
        }
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        if (!this.config.showButton() || !this.overlay.isMouseOver()) {
            return;
        }
        this.client.createMenuEntry(1).setOption("Check").setTarget(ColorUtil.wrapWithColorTag((String)"Usage", (Color)JagexColors.MENU_TARGET)).setType(MenuAction.RUNELITE).onClick(menuEntry -> this.showUsage());
        this.client.createMenuEntry(2).setOption(this.config.toggle() ? "Disable" : "Enable").setTarget(ColorUtil.wrapWithColorTag((String)"Plugin", (Color)JagexColors.MENU_TARGET)).setType(MenuAction.RUNELITE).onClick(menuEntry -> this.config.toggle(!this.config.toggle()));
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        PolywoofStorage.DataType type;
        String string;
        String header;
        if (!this.config.toggle()) {
            return;
        }
        switch (event.getType()) {
            case GAMEMESSAGE: {
                if (!this.config.test() && !this.config.enableMessages()) {
                    return;
                }
                header = event.getName();
                string = event.getMessage();
                type = PolywoofStorage.DataType.CHAT_MESSAGES;
                break;
            }
            case ITEM_EXAMINE: 
            case NPC_EXAMINE: 
            case OBJECT_EXAMINE: {
                if (!this.config.test() && !this.config.enableExamine()) {
                    return;
                }
                header = null;
                string = event.getMessage();
                type = PolywoofStorage.DataType.ANY_EXAMINE;
                break;
            }
            default: {
                return;
            }
        }
        PolywoofFormatter.parser(string, PolywoofFormatter.messageEntries, replacement -> {
            PolywoofComponent.Subject subject = this.dialogueSubject();
            if (this.config.test()) {
                this.overlay.put(PolywoofFormatter.filter(header), PolywoofFormatter.filter(replacement), subject);
            } else {
                this.translator.translate(replacement, PolywoofTranslator.languageFinder(this.config.language()), type, put -> this.overlay.put(PolywoofFormatter.filter(header), put, subject));
            }
        });
    }

    @Subscribe
    public void onOverheadTextChanged(OverheadTextChanged event) {
        if (!this.config.toggle() || !this.config.test() && !this.config.enableOverhead()) {
            return;
        }
        if (event.getActor() instanceof NPC) {
            PolywoofStorage.DataType type;
            String string;
            String header;
            NPC actor = (NPC)event.getActor();
            switch (actor.getId()) {
                default: {
                    header = actor.getName();
                    string = event.getOverheadText();
                    type = PolywoofStorage.DataType.OVERHEAD_TEXT;
                    break;
                }
                case 276: 
                case 277: 
                case 278: 
                case 279: 
                case 280: 
                case 6823: 
                case 10887: {
                    return;
                }
            }
            PolywoofFormatter.parser(string, PolywoofFormatter.overheadEntries, replacement -> {
                PolywoofComponent.Subject subject = this.dialogueSubject();
                if (this.config.test()) {
                    this.overlay.put(PolywoofFormatter.filter(header), PolywoofFormatter.filter(replacement), subject);
                } else {
                    this.translator.translate(replacement, PolywoofTranslator.languageFinder(this.config.language()), type, put -> this.overlay.put(PolywoofFormatter.filter(header), put, subject));
                }
            });
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        PolywoofStorage.DataType type;
        String string;
        String header;
        if (!this.config.toggle()) {
            this.previous = null;
            this.overlay.pop(null);
            return;
        }
        switch (this.dialogue) {
            case 119: {
                if (!this.config.test() && !this.config.enableDiary()) {
                    return;
                }
                header = this.widgets[0].getText();
                string = PolywoofFormatter.formatScrolls(new Widget[][]{this.widgets[1].getStaticChildren()});
                type = PolywoofStorage.DataType.QUEST_DIARY;
                break;
            }
            case 11: 
            case 193: 
            case 229: {
                header = null;
                string = this.widgets[0].getText();
                type = PolywoofStorage.DataType.DIALOGUE_TEXT;
                break;
            }
            case 203: {
                if (!this.config.test() && !this.config.enableClues()) {
                    return;
                }
                header = null;
                string = this.widgets[0].getText();
                type = PolywoofStorage.DataType.VARIOUS_SCROLLS;
                break;
            }
            case 217: 
            case 231: {
                header = this.widgets[0].getText();
                string = this.widgets[1].getText();
                type = PolywoofStorage.DataType.DIALOGUE_TEXT;
                break;
            }
            case 219: {
                header = null;
                string = PolywoofFormatter.formatOptions(this.widgets[0].getDynamicChildren());
                type = PolywoofStorage.DataType.DIALOGUE_OPTIONS;
                break;
            }
            case 95: 
            case 220: 
            case 222: {
                if (!this.config.test() && !this.config.enableScrolls()) {
                    return;
                }
                header = null;
                string = PolywoofFormatter.formatScrolls(new Widget[][]{this.widgets[0].getNestedChildren()});
                type = PolywoofStorage.DataType.VARIOUS_SCROLLS;
                break;
            }
            case 392: {
                if (!this.config.test() && !this.config.enableBooks()) {
                    return;
                }
                header = this.widgets[0].getText();
                string = PolywoofFormatter.formatScrolls(this.widgets[1].getStaticChildren(), this.widgets[2].getStaticChildren());
                type = PolywoofStorage.DataType.VARIOUS_BOOKS;
                break;
            }
            default: {
                return;
            }
        }
        if (string.equals(this.previous)) {
            return;
        }
        this.previous = string;
        this.overlay.pop(null);
        PolywoofFormatter.parser(string, PolywoofFormatter.dialogueEntries, replacement -> {
            PolywoofComponent.Subject subject = this.dialogueSubject(this.dialogue);
            if (this.config.test()) {
                this.overlay.set(null, PolywoofFormatter.filter(header), PolywoofFormatter.filter(replacement), subject);
            } else {
                this.translator.translate(replacement, PolywoofTranslator.languageFinder(this.config.language()), type, set -> this.overlay.set(null, PolywoofFormatter.filter(header), set, subject));
            }
        });
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        Widget[] loaded;
        switch (event.getGroupId()) {
            case 119: {
                loaded = new Widget[]{this.client.getWidget(WidgetInfo.DIARY_QUEST_WIDGET_TITLE), this.client.getWidget(WidgetInfo.DIARY_QUEST_WIDGET_TEXT)};
                break;
            }
            case 193: {
                loaded = new Widget[]{this.client.getWidget(WidgetInfo.DIALOG_SPRITE_TEXT)};
                break;
            }
            case 203: {
                loaded = new Widget[]{this.client.getWidget(WidgetInfo.CLUE_SCROLL_TEXT)};
                break;
            }
            case 217: {
                loaded = new Widget[]{this.client.getWidget(event.getGroupId(), 4), this.client.getWidget(WidgetInfo.DIALOG_PLAYER_TEXT)};
                break;
            }
            case 219: {
                loaded = new Widget[]{this.client.getWidget(WidgetInfo.DIALOG_OPTION_OPTIONS)};
                break;
            }
            case 231: {
                loaded = new Widget[]{this.client.getWidget(WidgetInfo.DIALOG_NPC_NAME), this.client.getWidget(WidgetInfo.DIALOG_NPC_TEXT)};
                break;
            }
            case 11: {
                loaded = new Widget[]{this.client.getWidget(event.getGroupId(), 2)};
                break;
            }
            case 95: 
            case 220: 
            case 222: {
                loaded = new Widget[]{this.client.getWidget(161, 16)};
                break;
            }
            case 229: {
                loaded = new Widget[]{this.client.getWidget(event.getGroupId(), 1)};
                break;
            }
            case 392: {
                loaded = new Widget[]{this.client.getWidget(event.getGroupId(), 6), this.client.getWidget(event.getGroupId(), 43), this.client.getWidget(event.getGroupId(), 59)};
                break;
            }
            default: {
                return;
            }
        }
        for (Widget widget : loaded) {
            if (widget != null) continue;
            return;
        }
        this.widgets = loaded;
        this.dialogue = event.getGroupId();
    }

    @Subscribe
    public void onWidgetClosed(WidgetClosed event) {
        switch (event.getGroupId()) {
            case 11: 
            case 95: 
            case 119: 
            case 193: 
            case 203: 
            case 217: 
            case 219: 
            case 220: 
            case 222: 
            case 229: 
            case 231: 
            case 392: {
                this.dialogue = 0;
                this.previous = null;
                this.overlay.pop(null);
            }
        }
    }

    public void showUsage() {
        this.translator.usage((characterCount, characterLimit) -> {
            String message = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Your current DeepL API usage is ").append(ChatColorType.HIGHLIGHT).append(Math.round(100.0f * ((float)characterCount / (float)characterLimit)) + "%").append(ChatColorType.NORMAL).append(" of the monthly quota!").build();
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
        });
    }

    private PolywoofComponent.Subject dialogueSubject(int dialogue) {
        if (dialogue == 219) {
            return this.config.numberedOptions() ? PolywoofComponent.Subject.NUMBERED : PolywoofComponent.Subject.OPTIONS;
        }
        return this.dialogueSubject();
    }

    private PolywoofComponent.Subject dialogueSubject() {
        return this.config.sourceName() ? PolywoofComponent.Subject.HEADER : PolywoofComponent.Subject.NONE;
    }

    public static class WidgetIDCustom {
        public static final int DIALOG_11 = 11;
        public static final int SCROLL_95 = 95;
        public static final int SCROLL_220 = 220;
        public static final int SCROLL_222 = 222;
        public static final int DIALOG_229 = 229;
        public static final int BOOK_392 = 392;
    }
}

