/*
 * Decompiled with CFR 0.152.
 */
package com.polywoof;

import com.polywoof.PolywoofComponent;
import com.polywoof.PolywoofConfig;
import com.polywoof.PolywoofPlugin;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class PolywoofOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(PolywoofOverlay.class);
    private static final BufferedImage buttonImage = ImageUtil.loadImageResource(PolywoofPlugin.class, (String)"/button.png");
    private static final Tooltip[] tooltips = new Tooltip[]{new Tooltip("Polywoof is " + ColorUtil.wrapWithColorTag((String)"Off", (Color)Color.RED)), new Tooltip("Polywoof is " + ColorUtil.wrapWithColorTag((String)"On", (Color)Color.GREEN))};
    private final Rectangle rectangle = new Rectangle(0, 0, 30, 30);
    private final Map<String, Subtitle> permanent = new HashMap<String, Subtitle>(1);
    private final List<Subtitle> temporary = new ArrayList<Subtitle>(9);
    private Font font;
    private AlphaComposite composite = AlphaComposite.getInstance(3);
    @Inject
    private Client client;
    @Inject
    private PolywoofConfig config;
    @Inject
    private TooltipManager tooltipManager;
    private boolean mouseOver;

    public Dimension render(Graphics2D graphics) {
        if (this.config.showButton() && !this.mouseOver) {
            this.composite = this.composite.derive(0.1f);
            graphics.setComposite(this.composite);
            graphics.drawImage(buttonImage, 0, 0, this.rectangle.width, this.rectangle.height, null);
        }
        ArrayList<Subtitle> copy = new ArrayList<Subtitle>(this.permanent.size() + this.temporary.size());
        copy.addAll(this.permanent.values());
        copy.addAll(this.temporary);
        if (!copy.isEmpty()) {
            PolywoofComponent.setPosition(this.getPreferredPosition() == null ? this.getPosition() : this.getPreferredPosition());
        }
        int offset = 0;
        for (Subtitle subtitle : copy) {
            if (subtitle.timestamp != 0L) {
                long difference = Math.max(0L, subtitle.timestamp - System.currentTimeMillis());
                if (difference == 0L) {
                    this.temporary.remove(subtitle);
                    continue;
                }
                subtitle.component.setAlpha(Math.min(1000.0f, (float)difference) / 1000.0f);
            }
            switch (PolywoofComponent.getAlignment()) {
                case TOP_LEFT: {
                    subtitle.component.setLocation(this.rectangle.x, this.rectangle.y + offset);
                    break;
                }
                case TOP_CENTER: {
                    subtitle.component.setLocation(this.rectangle.width / 2, this.rectangle.y + offset);
                    break;
                }
                case TOP_RIGHT: {
                    subtitle.component.setLocation(this.rectangle.width - this.rectangle.x, this.rectangle.y + offset);
                    break;
                }
                case BOTTOM_LEFT: {
                    subtitle.component.setLocation(this.rectangle.x, this.rectangle.height - this.rectangle.y - offset);
                    break;
                }
                case BOTTOM_CENTER: {
                    subtitle.component.setLocation(this.rectangle.width / 2, this.rectangle.height - this.rectangle.y - offset);
                    break;
                }
                case BOTTOM_RIGHT: {
                    subtitle.component.setLocation(this.rectangle.width - this.rectangle.x, this.rectangle.height - this.rectangle.y - offset);
                }
            }
            offset += subtitle.component.render((Graphics2D)graphics).height + 4;
        }
        if (this.mouseOver) {
            if (this.config.showButton()) {
                this.composite = this.composite.derive(1.0f);
                graphics.setComposite(this.composite);
                graphics.drawImage(buttonImage, 0, 0, this.rectangle.width, this.rectangle.height, null);
                if (!this.client.isMenuOpen()) {
                    this.tooltipManager.add(tooltips[this.config.toggle() ? 1 : 0]);
                }
            }
            this.mouseOver = false;
        }
        return this.rectangle.getSize();
    }

    public void onMouseOver() {
        this.mouseOver = true;
    }

    public void revalidate() {
        this.font = new Font(this.config.fontName(), 0, this.config.fontSize());
        PolywoofComponent.setTextWrap(this.config.textWrap());
        PolywoofComponent.setTextShadow(this.config.textShadow());
        PolywoofComponent.setBoxOutline(this.config.overlayOutline());
        PolywoofComponent.setBackgroundColor(this.config.overlayColor());
        PolywoofComponent.setBehaviour(this.config.textAlignment());
        for (Subtitle subtitle : this.permanent.values()) {
            subtitle.component.setFontSize(this.config.fontSize());
            subtitle.component.setHeaderSubject(this.config.sourceName());
            subtitle.component.setNumberedSubject(this.config.numberedOptions());
            subtitle.component.revalidate();
        }
        for (Subtitle subtitle : this.temporary) {
            subtitle.component.setFontSize(this.config.fontSize());
            subtitle.component.setHeaderSubject(this.config.sourceName());
            subtitle.component.setNumberedSubject(this.config.numberedOptions());
            subtitle.component.revalidate();
        }
    }

    public void put(@Nullable String header, String string, PolywoofComponent.Subject subject) {
        if (string.isEmpty()) {
            return;
        }
        if (this.temporary.size() >= 9) {
            this.temporary.remove(this.temporary.size() - 1);
        }
        this.temporary.add(0, Subtitle.temporary(new PolywoofComponent(header, string, this.font, subject), System.currentTimeMillis() + 1500L + (long)((float)string.length() * 1000.0f * (1.0f / (float)this.config.readingSpeed()))));
    }

    public void set(@Nullable String key, @Nullable String header, String string, PolywoofComponent.Subject subject) {
        if (string.isEmpty()) {
            return;
        }
        if (this.permanent.containsKey(key)) {
            this.pop(key);
        }
        this.permanent.put(key, Subtitle.permanent(new PolywoofComponent(header, string, this.font, subject)));
    }

    public void pop(@Nullable String key) {
        if (!this.permanent.containsKey(key)) {
            return;
        }
        if (this.temporary.size() >= 9) {
            this.temporary.remove(this.temporary.size() - 1);
        }
        this.temporary.add(0, Subtitle.temporary(this.permanent.get((Object)key).component, System.currentTimeMillis() + 1500L));
        this.permanent.remove(key);
    }

    public void reset() {
        this.permanent.clear();
        this.temporary.clear();
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    public static class Subtitle {
        public final PolywoofComponent component;
        public final long timestamp;

        public static Subtitle permanent(PolywoofComponent component) {
            return new Subtitle(component, 0L);
        }

        public static Subtitle temporary(PolywoofComponent component, long timestamp) {
            return new Subtitle(component, timestamp);
        }

        private Subtitle(PolywoofComponent component, long timestamp) {
            this.component = component;
            this.timestamp = timestamp;
        }
    }
}

