/*
 * Decompiled with CFR 0.152.
 */
package com.polywoof;

import com.polywoof.PolywoofComponent;
import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;
import net.runelite.client.ui.overlay.components.ComponentConstants;

@ConfigGroup(value="polywoof")
public interface PolywoofConfig
extends Config {
    @ConfigSection(name="Primary", description="Most important", position=0)
    public static final String primarySection = "primarySection";
    @ConfigSection(name="Translation", description="What will be translated", position=1)
    public static final String translationSection = "translationSection";
    @ConfigSection(name="Visual", description="Font and visual appearance", position=2)
    public static final String visualSection = "visualSection";
    @ConfigSection(name="Formatting", description="Text formatting", position=3)
    public static final String formattingSection = "formattingSection";

    @ConfigItem(keyName="toggle", name="", description="", hidden=true)
    default public boolean toggle() {
        return true;
    }

    @ConfigItem(keyName="toggle", name="", description="")
    public void toggle(boolean var1);

    @ConfigItem(keyName="language", name="Target Language", description="Type your desired one, \u00abru\u00bb for russian, \u00abfr\u00bb french, etc", section="primarySection", position=0)
    default public String language() {
        return "ru";
    }

    @ConfigItem(keyName="key", name="DeepL API Key", description="This is REQUIRED, see www.DeepL.com", secret=true, section="primarySection", position=1)
    default public String key() {
        return "";
    }

    @Range(min=1, max=99)
    @ConfigItem(keyName="readingSpeed", name="Reading Skill", description="How quickly do you read", section="primarySection", position=2)
    default public int readingSpeed() {
        return 10;
    }

    @ConfigItem(keyName="showUsage", name="Show API Usage", description="See your monthly usage on logon", section="primarySection", position=3)
    default public boolean showUsage() {
        return true;
    }

    @ConfigItem(keyName="showButton", name="Show Button", description="Quality of life feature", section="primarySection", position=4)
    default public boolean showButton() {
        return true;
    }

    @ConfigItem(keyName="test", name="Test Mode", description="It makes everything useless", warning="Are you sure you want to toggle the translation?", section="primarySection", position=5)
    default public boolean test() {
        return false;
    }

    @ConfigItem(keyName="enableMessages", name="Chat Messages", description="Translate chat messages", section="translationSection", position=0)
    default public boolean enableMessages() {
        return true;
    }

    @ConfigItem(keyName="enableExamine", name="Examine", description="Translate any examine", section="translationSection", position=1)
    default public boolean enableExamine() {
        return true;
    }

    @ConfigItem(keyName="enableOverhead", name="Overhead Text", description="Translate overhead text", section="translationSection", position=2)
    default public boolean enableOverhead() {
        return false;
    }

    @ConfigItem(keyName="enableScrolls", name="Scrolls", description="Translate various scrolls", section="translationSection", position=3)
    default public boolean enableScrolls() {
        return false;
    }

    @ConfigItem(keyName="enableBooks", name="Books", description="Translate various books", warning="It uses a huge amount of resources to translate! Are you sure?", section="translationSection", position=4)
    default public boolean enableBooks() {
        return false;
    }

    @ConfigItem(keyName="enableClues", name="Treasure Clues", description="Translate treasure clues", section="translationSection", position=5)
    default public boolean enableClues() {
        return false;
    }

    @ConfigItem(keyName="enableDiary", name="Quest Diary", description="Translate quest diary", warning="It uses a lot of resources to translate! Are you sure?", section="translationSection", position=6)
    default public boolean enableDiary() {
        return false;
    }

    @ConfigItem(keyName="fontName", name="Font Name", description="Check a fonts viewer", section="visualSection", position=0)
    default public String fontName() {
        return "Consolas";
    }

    @Range(min=1, max=99)
    @ConfigItem(keyName="fontSize", name="Font Size", description="Why it does matter", section="visualSection", position=1)
    default public int fontSize() {
        return 12;
    }

    @ConfigItem(keyName="textShadow", name="Text Shadow", description="Suspicious shadowy text", section="visualSection", position=2)
    default public boolean textShadow() {
        return true;
    }

    @Alpha
    @ConfigItem(keyName="overlayColor", name="Background Color", description="Any color is acceptable", section="visualSection", position=3)
    default public Color overlayColor() {
        return ComponentConstants.STANDARD_BACKGROUND_COLOR;
    }

    @ConfigItem(keyName="overlayOutline", name="Show Outline", description="Make it.. pretty", section="visualSection", position=4)
    default public boolean overlayOutline() {
        return true;
    }

    @ConfigItem(keyName="textAlignment", name="Text Alignment", description="Move it to the right place", section="formattingSection", position=0)
    default public PolywoofComponent.Behaviour textAlignment() {
        return PolywoofComponent.Behaviour.DEFAULT;
    }

    @Range(min=32, max=2277)
    @ConfigItem(keyName="textWrap", name="Text Wrap Width", description="Longest text ever", section="formattingSection", position=1)
    default public int textWrap() {
        return 420;
    }

    @ConfigItem(keyName="sourceName", name="Source Name", description="Tell me who said that", section="formattingSection", position=2)
    default public boolean sourceName() {
        return true;
    }

    @ConfigItem(keyName="numberedOptions", name="Numbered Options", description="Let's count up to ten", section="formattingSection", position=3)
    default public boolean numberedOptions() {
        return true;
    }
}

