/*
 * Decompiled with CFR 0.152.
 */
package com.polywoof;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.RenderableEntity;
import net.runelite.client.ui.overlay.components.ComponentConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class PolywoofComponent
implements RenderableEntity {
    private static final Logger log = LoggerFactory.getLogger(PolywoofComponent.class);
    private static int textWrap;
    private static boolean textShadow;
    private static boolean boxOutline;
    private static Color backgroundColor;
    private static Alignment alignment;
    private static Behaviour behaviour;
    private final Rectangle rectangle = new Rectangle();
    private final List<List<String>> paragraphs = new ArrayList<List<String>>(10);
    private final String header;
    private final String string;
    private Font font;
    private Subject subject;
    private AlphaComposite composite = AlphaComposite.getInstance(3);
    private boolean revalidate;

    public PolywoofComponent(@Nullable String header, String string, Font font, Subject subject) {
        if (header != null && header.isEmpty()) {
            header = null;
        }
        if (header == null && subject == Subject.HEADER) {
            subject = Subject.NONE;
        }
        this.header = header;
        this.string = string;
        this.font = font;
        this.subject = subject;
        this.revalidate();
    }

    public static void setPosition(OverlayPosition position) {
        switch (position) {
            case TOP_LEFT: {
                PolywoofComponent.setAlignment(Alignment.TOP_LEFT);
                break;
            }
            case TOP_CENTER: {
                PolywoofComponent.setAlignment(Alignment.TOP_CENTER);
                break;
            }
            case TOP_RIGHT: 
            case CANVAS_TOP_RIGHT: {
                PolywoofComponent.setAlignment(Alignment.TOP_RIGHT);
                break;
            }
            case BOTTOM_LEFT: {
                PolywoofComponent.setAlignment(Alignment.BOTTOM_LEFT);
                break;
            }
            default: {
                PolywoofComponent.setAlignment(Alignment.BOTTOM_CENTER);
                break;
            }
            case BOTTOM_RIGHT: {
                PolywoofComponent.setAlignment(Alignment.BOTTOM_RIGHT);
            }
        }
    }

    public Dimension render(Graphics2D graphics) {
        if (this.revalidate) {
            this.update(graphics);
        }
        int x = 0;
        int y = 0;
        switch (alignment) {
            case TOP_LEFT: 
            case BOTTOM_LEFT: {
                x = this.rectangle.x;
                break;
            }
            case TOP_CENTER: 
            case BOTTOM_CENTER: {
                x = this.rectangle.x - this.rectangle.width / 2;
                break;
            }
            case TOP_RIGHT: 
            case BOTTOM_RIGHT: {
                x = this.rectangle.x - this.rectangle.width;
            }
        }
        switch (alignment) {
            case TOP_LEFT: 
            case TOP_CENTER: 
            case TOP_RIGHT: {
                y = this.rectangle.y;
                break;
            }
            case BOTTOM_LEFT: 
            case BOTTOM_CENTER: 
            case BOTTOM_RIGHT: {
                y = this.rectangle.y - this.rectangle.height;
            }
        }
        graphics.setFont(this.font);
        graphics.setComposite(this.composite);
        graphics.setColor(backgroundColor);
        graphics.fillRect(x, y, this.rectangle.width, this.rectangle.height);
        if (boxOutline) {
            graphics.setColor(backgroundColor.darker());
            graphics.drawRect(x, y, this.rectangle.width - 1, this.rectangle.height - 1);
            graphics.setColor(backgroundColor.brighter());
            graphics.drawRect(x + 1, y + 1, this.rectangle.width - 3, this.rectangle.height - 3);
        }
        int offset = 0;
        boolean plain = this.subject == Subject.NONE;
        FontMetrics metrics = graphics.getFontMetrics(this.font);
        for (List<String> paragraph : this.paragraphs) {
            for (String line : paragraph) {
                block9 : switch (alignment) {
                    case TOP_LEFT: 
                    case BOTTOM_LEFT: {
                        if (plain) {
                            switch (behaviour) {
                                default: {
                                    x = this.rectangle.x + metrics.getDescent() * 2;
                                    break block9;
                                }
                                case FORCE_CENTER: {
                                    x = this.rectangle.x + this.rectangle.width / 2 - metrics.stringWidth(line) / 2;
                                    break block9;
                                }
                                case FORCE_RIGHT: 
                            }
                            x = this.rectangle.x + this.rectangle.width - metrics.getDescent() * 2 - metrics.stringWidth(line);
                            break;
                        }
                        x = this.rectangle.x + this.rectangle.width / 2 - metrics.stringWidth(line) / 2;
                        break;
                    }
                    case TOP_CENTER: 
                    case BOTTOM_CENTER: {
                        if (plain) {
                            switch (behaviour) {
                                case FORCE_LEFT: {
                                    x = this.rectangle.x - this.rectangle.width / 2 + metrics.getDescent() * 2;
                                    break block9;
                                }
                                default: {
                                    x = this.rectangle.x - metrics.stringWidth(line) / 2;
                                    break block9;
                                }
                                case FORCE_RIGHT: 
                            }
                            x = this.rectangle.x + this.rectangle.width / 2 - metrics.getDescent() * 2 - metrics.stringWidth(line);
                            break;
                        }
                        x = this.rectangle.x - metrics.stringWidth(line) / 2;
                        break;
                    }
                    case TOP_RIGHT: 
                    case BOTTOM_RIGHT: {
                        if (plain) {
                            switch (behaviour) {
                                case FORCE_LEFT: {
                                    x = this.rectangle.x - this.rectangle.width + metrics.getDescent() * 2;
                                    break block9;
                                }
                                case FORCE_CENTER: {
                                    x = this.rectangle.x - this.rectangle.width / 2 - metrics.stringWidth(line) / 2;
                                    break block9;
                                }
                            }
                            x = this.rectangle.x - metrics.getDescent() * 2 - metrics.stringWidth(line);
                            break;
                        }
                        x = this.rectangle.x - this.rectangle.width / 2 - metrics.stringWidth(line) / 2;
                    }
                }
                switch (alignment) {
                    case TOP_LEFT: 
                    case TOP_CENTER: 
                    case TOP_RIGHT: {
                        y = this.rectangle.y + metrics.getDescent() * 2 + offset + metrics.getAscent();
                        break;
                    }
                    case BOTTOM_LEFT: 
                    case BOTTOM_CENTER: 
                    case BOTTOM_RIGHT: {
                        y = this.rectangle.y + metrics.getDescent() * 2 + offset + metrics.getAscent() - this.rectangle.height;
                    }
                }
                if (textShadow) {
                    graphics.setColor(Color.BLACK);
                    graphics.drawString(line, x + 1, y + 1);
                }
                graphics.setColor(plain ? Color.WHITE : JagexColors.MENU_TARGET);
                graphics.drawString(line, x, y);
                offset += metrics.getAscent() + metrics.getDescent();
            }
            offset = (int)((float)offset + (float)metrics.getDescent() * ((this.subject == Subject.NONE || this.subject == Subject.HEADER) && plain ? 1.0f : 0.5f));
            plain = true;
        }
        return this.rectangle.getSize();
    }

    public Dimension update(Graphics2D graphics) {
        if (!this.revalidate) {
            return this.rectangle.getSize();
        }
        this.revalidate = false;
        this.paragraphs.clear();
        this.rectangle.setSize(0, 0);
        int index = -1;
        FontMetrics metrics = graphics.getFontMetrics(this.font);
        for (String split : (this.subject == Subject.HEADER ? String.format("%s\n%s", this.header, this.string) : this.string).split("\n")) {
            ArrayList<String> paragraph = new ArrayList<String>(10);
            if (this.subject == Subject.NUMBERED && ++index != 0) {
                paragraph.add(String.format("%d. %s", index, split));
            } else {
                paragraph.add(split);
            }
            block4: for (int i = 0; i < paragraph.size(); ++i) {
                String line = (String)paragraph.get(i);
                if (metrics.stringWidth(line) <= textWrap - metrics.getDescent() * 4) {
                    this.rectangle.width = Math.max(this.rectangle.width, metrics.stringWidth(line));
                    continue;
                }
                int wrap = 0;
                int word = 0;
                block5: for (int j = 0; j < line.length(); ++j) {
                    if (metrics.charsWidth(line.toCharArray(), 0, j + 1) > textWrap - metrics.getDescent() * 4) {
                        int cut = Math.min(wrap, word);
                        if (cut == 0 && (cut = Math.max(wrap, word)) == 0) continue block4;
                        String begin = line.substring(0, cut);
                        String end = line.substring(cut);
                        paragraph.set(i, begin);
                        if (!end.isEmpty()) {
                            paragraph.add(i + 1, end);
                        }
                        this.rectangle.width = Math.max(this.rectangle.width, metrics.stringWidth(begin));
                        continue block4;
                    }
                    switch (line.charAt(j)) {
                        case ' ': 
                        case ',': 
                        case '-': 
                        case '.': 
                        case ':': 
                        case ';': {
                            wrap = j + 1;
                            word = 0;
                            continue block5;
                        }
                        default: {
                            word = j;
                        }
                    }
                }
            }
            this.rectangle.height += metrics.getAscent() * paragraph.size() + metrics.getDescent() * (paragraph.size() - 1);
            this.paragraphs.add(paragraph);
        }
        if (this.paragraphs.size() > 1) {
            if (this.subject == Subject.HEADER) {
                this.rectangle.height = (int)((float)this.rectangle.height - (float)metrics.getDescent() * 0.5f);
            }
            this.rectangle.height = (int)((float)this.rectangle.height + (float)metrics.getDescent() * (this.subject == Subject.NONE || this.subject == Subject.HEADER ? 2.0f : 1.5f) * (float)(this.paragraphs.size() - 1));
        }
        this.rectangle.width += metrics.getDescent() * 4;
        this.rectangle.height += metrics.getDescent() * 4;
        log.debug("[{}x{}]", (Object)this.rectangle.width, (Object)this.rectangle.height);
        return this.rectangle.getSize();
    }

    public void setLocation(int x, int y) {
        this.rectangle.setLocation(x, y);
    }

    public void setFontSize(int size) {
        if (size == this.font.getSize()) {
            return;
        }
        this.font = this.font.deriveFont((float)size);
    }

    public void setHeaderSubject(boolean toggle) {
        if (this.header == null || this.subject == Subject.OPTIONS || this.subject == Subject.NUMBERED) {
            return;
        }
        this.subject = toggle ? Subject.HEADER : Subject.NONE;
    }

    public void setNumberedSubject(boolean toggle) {
        if (this.subject == Subject.NONE || this.subject == Subject.HEADER) {
            return;
        }
        this.subject = toggle ? Subject.NUMBERED : Subject.OPTIONS;
    }

    public void setAlpha(float opacity) {
        this.composite = this.composite.derive(opacity);
    }

    public void revalidate() {
        this.revalidate = true;
    }

    public static void setTextWrap(int textWrap) {
        PolywoofComponent.textWrap = textWrap;
    }

    public static void setTextShadow(boolean textShadow) {
        PolywoofComponent.textShadow = textShadow;
    }

    public static void setBoxOutline(boolean boxOutline) {
        PolywoofComponent.boxOutline = boxOutline;
    }

    public static void setBackgroundColor(Color backgroundColor) {
        PolywoofComponent.backgroundColor = backgroundColor;
    }

    public static void setAlignment(Alignment alignment) {
        PolywoofComponent.alignment = alignment;
    }

    public static Alignment getAlignment() {
        return alignment;
    }

    public static void setBehaviour(Behaviour behaviour) {
        PolywoofComponent.behaviour = behaviour;
    }

    public static Behaviour getBehaviour() {
        return behaviour;
    }

    static {
        backgroundColor = ComponentConstants.STANDARD_BACKGROUND_COLOR;
        alignment = Alignment.BOTTOM_LEFT;
        behaviour = Behaviour.DEFAULT;
    }

    public static enum Subject {
        NONE,
        HEADER,
        OPTIONS,
        NUMBERED;

    }

    public static enum Behaviour {
        DEFAULT,
        FORCE_LEFT,
        FORCE_CENTER,
        FORCE_RIGHT;

    }

    public static enum Alignment {
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;

    }
}

