/*
 * Decompiled with CFR 0.152.
 */
package com.brewing;

import com.brewing.BrewingConfig;
import com.brewing.BrewingPlugin;
import com.brewing.BrewingVatState;
import java.awt.Color;
import java.awt.image.BufferedImage;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxPriority;

public class BrewingVat
extends InfoBox {
    private final String location;
    private final int vat;
    private final BrewingPlugin plugin;
    private final BrewingConfig config;

    BrewingVat(String location, int vat_val, BufferedImage image, BrewingPlugin plugin, BrewingConfig config) {
        super(image, (Plugin)plugin);
        this.vat = vat_val;
        this.location = location;
        this.plugin = plugin;
        this.config = config;
        this.setPriority(InfoBoxPriority.LOW);
    }

    public String getText() {
        return this.location.substring(0, 1);
    }

    public String getTooltip() {
        return this.location + " - " + BrewingVatState.toString(this.vat);
    }

    public Color getTextColor() {
        if (BrewingVatState.isBad(this.vat)) {
            return Color.RED;
        }
        if (BrewingVatState.isCompletedMature(this.vat)) {
            return Color.BLUE;
        }
        if (BrewingVatState.isCompletedNormal(this.vat)) {
            return Color.GREEN;
        }
        if (BrewingVatState.isPartial(this.vat)) {
            return Color.YELLOW;
        }
        return Color.WHITE;
    }

    public boolean render() {
        return this.canDisplayVat() && this.canDisplayVatCond();
    }

    private boolean canDisplayVat() {
        if (this.config.displayVats() == BrewingConfig.DisplayMode.BOTH) {
            return true;
        }
        if (this.location == "Keldagrim" && this.config.displayVats() == BrewingConfig.DisplayMode.KELDAGRIM) {
            return true;
        }
        return this.location == "Port Phasmatys" && this.config.displayVats() == BrewingConfig.DisplayMode.PORT_PHASMATYS;
    }

    private boolean canDisplayVatCond() {
        if (this.config.vatDisplayCond() == BrewingConfig.VatState.ALWAYS) {
            return true;
        }
        if (this.vat != BrewingVatState.EMPTY.getValue() && this.config.vatDisplayCond() == BrewingConfig.VatState.ANY_CONTENTS) {
            return true;
        }
        return (BrewingVatState.isBad(this.vat) || BrewingVatState.isCompletedNormal(this.vat) || BrewingVatState.isCompletedMature(this.vat)) && this.config.vatDisplayCond() == BrewingConfig.VatState.COMPLETION;
    }
}

