/*
 * Decompiled with CFR 0.152.
 */
package com.brewing;

import com.brewing.BrewingBarrel;
import com.brewing.BrewingConfig;
import com.brewing.BrewingVat;
import com.brewing.BrewingVatState;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.Notifier;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Brewing", description="Brewing Overlay", tags={"cooking", "skilling", "overlay"})
public class BrewingPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BrewingPlugin.class);
    @Inject
    private Client client;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private Notifier notifier;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private BrewingConfig config;
    public static final String KELDAGRIM_NAME = "Keldagrim";
    private static final int KELDAGRIM_VAT_VARBIT = 736;
    private static final int KELDAGRIM_STUFF_VARBIT = 2294;
    private static final int KELDAGRIM_BARREL_VARBIT = 738;
    public static final String PORT_PHASMATYS_NAME = "Port Phasmatys";
    private static final int PORT_PHASMATYS_VAT_VARBIT = 737;
    private static final int PORT_PHASMATYS_STUFF_VARBIT = 2295;
    private static final int PORT_PHASMATYS_BARREL_VARBIT = 739;
    private boolean infoboxInit;
    private static final BufferedImage VAT_IMAGE = ImageUtil.loadImageResource(BrewingPlugin.class, (String)"/com/brewing/vat.png");
    private static final BufferedImage BARREL_IMAGE = ImageUtil.loadImageResource(BrewingPlugin.class, (String)"/com/brewing/barrel.png");
    private static final BufferedImage THE_STUFF_VAT_IMAGE = ImageUtil.loadImageResource(BrewingPlugin.class, (String)"/com/brewing/vat_stuff.png");

    @Provides
    BrewingConfig provideConfig(ConfigManager configManager) {
        return (BrewingConfig)configManager.getConfig(BrewingConfig.class);
    }

    protected void startUp() {
        this.infoboxInit = false;
    }

    protected void shutDown() {
        this.removeInfoBoxes();
        this.infoboxInit = false;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        if (!e.getGroup().equals("BrewingConfig")) {
            return;
        }
        this.infoboxInit = false;
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        int var = varbitChanged.getVarbitId();
        if ((var == 736 || var == 737) && (BrewingVatState.isCompletedNormal(varbitChanged.getValue()) || BrewingVatState.isCompletedMature(varbitChanged.getValue()))) {
            if (this.config.notifyOnCompletion()) {
                this.notifier.notify("You have " + BrewingVatState.toString(varbitChanged.getValue()) + " waiting to be collected in the " + (var == 736 ? KELDAGRIM_NAME : PORT_PHASMATYS_NAME) + " vat.");
            }
            if (this.config.chatMessageOnCompletion()) {
                this.sendChatMessage("You have " + BrewingVatState.toString(varbitChanged.getValue()) + " waiting to be collected in the " + (var == 736 ? KELDAGRIM_NAME : PORT_PHASMATYS_NAME) + " vat.");
            }
        }
        if (var == 736 || var == 737 || var == 2294 || var == 2295 || var == 738 || var == 739) {
            this.removeInfoBoxes();
            this.addInfoBoxes();
        }
    }

    private void addInfoBoxes() {
        BufferedImage KELDAGRIM_VAT_IMAGE = this.client.getVarbitValue(2294) == 1 ? THE_STUFF_VAT_IMAGE : VAT_IMAGE;
        BufferedImage PORT_PHASMATYS_VAT_IMAGE = this.client.getVarbitValue(2295) == 1 ? THE_STUFF_VAT_IMAGE : VAT_IMAGE;
        this.infoBoxManager.addInfoBox((InfoBox)new BrewingVat(KELDAGRIM_NAME, this.client.getVarbitValue(736), KELDAGRIM_VAT_IMAGE, this, this.config));
        this.infoBoxManager.addInfoBox((InfoBox)new BrewingVat(PORT_PHASMATYS_NAME, this.client.getVarbitValue(737), PORT_PHASMATYS_VAT_IMAGE, this, this.config));
        this.infoBoxManager.addInfoBox((InfoBox)new BrewingBarrel(KELDAGRIM_NAME, this.client.getVarbitValue(738), BARREL_IMAGE, this, this.config));
        this.infoBoxManager.addInfoBox((InfoBox)new BrewingBarrel(PORT_PHASMATYS_NAME, this.client.getVarbitValue(739), BARREL_IMAGE, this, this.config));
    }

    private void removeInfoBoxes() {
        this.infoBoxManager.removeIf(t -> t instanceof BrewingVat || t instanceof BrewingBarrel);
    }

    private void sendChatMessage(String chatMessage) {
        String message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(chatMessage).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
    }
}

