/*
 * Decompiled with CFR 0.152.
 */
package com.brewing;

import com.brewing.BrewingBarrelState;
import com.brewing.BrewingConfig;
import com.brewing.BrewingPlugin;
import java.awt.Color;
import java.awt.image.BufferedImage;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxPriority;

public class BrewingBarrel
extends InfoBox {
    private final String location;
    private final int barrel;
    private final BrewingPlugin plugin;
    private final BrewingConfig config;

    BrewingBarrel(String location, int barrel_varbit, BufferedImage image, BrewingPlugin plugin, BrewingConfig config) {
        super(image, (Plugin)plugin);
        this.barrel = barrel_varbit;
        this.location = location;
        this.plugin = plugin;
        this.config = config;
        this.setPriority(InfoBoxPriority.LOW);
    }

    public String getText() {
        return this.location.substring(0, 1);
    }

    public String getTooltip() {
        return this.location + " - " + BrewingBarrelState.toString(this.barrel);
    }

    public Color getTextColor() {
        if (BrewingBarrelState.isDrainable(this.barrel)) {
            return Color.RED;
        }
        if (BrewingBarrelState.hasMatureContents(this.barrel)) {
            return Color.BLUE;
        }
        if (BrewingBarrelState.hasNormalContents(this.barrel)) {
            return Color.GREEN;
        }
        return Color.WHITE;
    }

    public boolean render() {
        return this.canDisplayBarrel() && this.canDisplayBarrelCond();
    }

    private boolean canDisplayBarrel() {
        if (this.config.displayBarrels() == BrewingConfig.DisplayMode.BOTH) {
            return true;
        }
        if (this.location == "Keldagrim" && this.config.displayBarrels() == BrewingConfig.DisplayMode.KELDAGRIM) {
            return true;
        }
        return this.location == "Port Phasmatys" && this.config.displayBarrels() == BrewingConfig.DisplayMode.PORT_PHASMATYS;
    }

    private boolean canDisplayBarrelCond() {
        if (this.config.barrelDisplayCond() == BrewingConfig.BarrelState.ALWAYS) {
            return true;
        }
        if (this.barrel != BrewingBarrelState.EMPTY.getValue() && this.config.barrelDisplayCond() == BrewingConfig.BarrelState.NOT_EMPTY) {
            return true;
        }
        return BrewingBarrelState.isFull(this.barrel) && this.config.barrelDisplayCond() == BrewingConfig.BarrelState.FULL;
    }
}

