/*
 * Decompiled with CFR 0.152.
 */
package com.decimalprices;

import java.math.BigDecimal;

public class DecimalPricesUtil {
    private static final BigDecimal ONE_THOUSAND = new BigDecimal(1000);
    private static final BigDecimal ONE_MILLION = new BigDecimal(1000000);
    private static final BigDecimal ONE_BILLION = new BigDecimal(1000000000);
    private static final BigDecimal MAX = new BigDecimal(Integer.MAX_VALUE);

    public static String transformDecimalPrice(String decimalPrice) {
        BigDecimal product;
        int priceStringLen = decimalPrice.length();
        char unit = decimalPrice.charAt(priceStringLen - 1);
        BigDecimal amount = new BigDecimal(decimalPrice.substring(0, priceStringLen - 1));
        switch (unit) {
            case 'k': {
                product = amount.multiply(ONE_THOUSAND);
                break;
            }
            case 'm': {
                product = amount.multiply(ONE_MILLION);
                break;
            }
            case 'b': {
                product = amount.multiply(ONE_BILLION);
                break;
            }
            default: {
                product = BigDecimal.ZERO;
            }
        }
        if (product.compareTo(MAX) > 0) {
            product = MAX;
        }
        int truncatedProduct = product.intValue();
        return String.valueOf(truncatedProduct);
    }
}

