/*
 * Decompiled with CFR 0.152.
 */
package com.decimalprices;

import com.decimalprices.DecimalPricesUtil;
import java.awt.event.KeyEvent;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.input.KeyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DecimalPricesKeyListener
implements KeyListener {
    private static final Logger log = LoggerFactory.getLogger(DecimalPricesKeyListener.class);
    @Inject
    private Client client;

    DecimalPricesKeyListener() {
    }

    private boolean isQuantityInput() {
        return this.client.getVarcIntValue(5) == 7;
    }

    private void convertQuantity() {
        String rawInputText = this.client.getVarcStrValue(359);
        String lowerInputText = rawInputText.toLowerCase();
        if (!lowerInputText.matches("[0-9]+\\.[0-9]+[kmb]")) {
            return;
        }
        String transformedPrice = DecimalPricesUtil.transformDecimalPrice(lowerInputText);
        this.client.setVarcStrValue(359, transformedPrice);
    }

    private void addDecimalToInputText() {
        String currentInputText = this.client.getVarcStrValue(359);
        if (currentInputText.equals("")) {
            return;
        }
        if (currentInputText.contains(".")) {
            return;
        }
        String newInputText = currentInputText + ".";
        this.client.setVarcStrValue(359, newInputText);
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && this.isQuantityInput()) {
            this.convertQuantity();
        } else if ((e.getKeyCode() == 46 || e.getKeyCode() == 110) && this.isQuantityInput()) {
            this.addDecimalToInputText();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

