/*
 * Decompiled with CFR 0.152.
 */
package com.zom;

import com.google.inject.Provides;
import com.zom.BossKickerConfig;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Boss Kicker", description="Kick bosses awake")
public class BossKicker
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BossKicker.class);
    @Inject
    private Client client;
    @Inject
    private BossKickerConfig config;
    private LocalPoint supportedKick;
    private NPC genericNPC;
    List<String> kickOptions;
    List<String> bossesToKick;

    public void startUp() {
        this.configSet();
    }

    public void shutDown() {
        this.kickOptions.clear();
        this.bossesToKick.clear();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("BossKicker")) {
            this.configSet();
        }
    }

    @Provides
    BossKickerConfig getConfig(ConfigManager configManager) {
        return (BossKickerConfig)configManager.getConfig(BossKickerConfig.class);
    }

    private void configSet() {
        this.kickOptions = Text.fromCSV((String)this.config.bossWakeUpOptions());
        this.bossesToKick = Text.fromCSV((String)this.config.bossNames());
        if (this.kickOptions.size() != this.bossesToKick.size()) {
            log.info("Bosses to kick and kick options are not equal in length");
            this.bossesToKick.clear();
            this.kickOptions.clear();
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked e) {
        String target = Text.removeFormattingTags((String)e.getMenuTarget());
        int index = this.bossesToKick.indexOf(target);
        if (index != -1) {
            String option = Text.removeFormattingTags((String)e.getMenuOption());
            if (this.kickOptions.get(index).equals(option)) {
                this.supportedKick = LocalPoint.fromScene((int)e.getParam0(), (int)e.getParam1());
            }
        } else {
            this.supportedKick = null;
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        String npcName = event.getNpc().getName();
        if (this.bossesToKick.contains(npcName)) {
            this.genericNPC = event.getNpc();
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        String npcName = event.getNpc().getName();
        if (this.bossesToKick.contains(npcName)) {
            this.genericNPC = null;
        }
    }

    @Subscribe
    public void onClientTick(ClientTick e) {
        if (this.genericNPC != null && this.supportedKick != null) {
            Player local = this.client.getLocalPlayer();
            if (this.genericNPC.getWorldArea().distanceTo(local.getWorldArea()) == 1) {
                local.setAnimation(423);
                local.setActionFrame(0);
                this.supportedKick = null;
            }
        }
    }
}

