/*
 * Decompiled with CFR 0.152.
 */
package gim.bank.discord;

import com.google.inject.Provides;
import gim.bank.discord.DiscordWebhookBody;
import gim.bank.discord.GimBankDiscordConfig;
import gim.bank.discord.SimpleItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="GIM Bank Discord")
public class GimBankDiscordPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GimBankDiscordPlugin.class);
    @Inject
    private Client client;
    @Inject
    private GimBankDiscordConfig config;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    private List<SimpleItem> inventoryItems = Collections.emptyList();

    protected void startUp() throws Exception {
        log.info("GIM Bank Discord started!");
    }

    protected void shutDown() throws Exception {
        log.info("GIM Bank Discord stopped!");
    }

    @Subscribe
    void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() != 725) {
            return;
        }
        log.info("Opened GIM Bank");
        if (this.client.getItemContainer(InventoryID.GROUP_STORAGE_INV) != null) {
            this.inventoryItems = this.getItemsFromContainer(this.client.getItemContainer(InventoryID.GROUP_STORAGE_INV));
        }
    }

    @Subscribe
    void onWidgetClosed(WidgetClosed event) {
        if (event.getGroupId() != 293) {
            return;
        }
        String messageText = this.client.getWidget(293, 1).getText();
        if (!messageText.contains("Saving")) {
            return;
        }
        log.info("SAVING!");
        this.afterClose();
    }

    private void afterClose() {
        List<SimpleItem> exitItems = this.getItemsFromContainer(this.client.getItemContainer(InventoryID.INVENTORY));
        List<SimpleItem> diff = this.getDiff(this.canonicalizeItemList(this.inventoryItems), this.canonicalizeItemList(exitItems));
        if (diff.size() > 0) {
            this.sendDiscordMessage(this.createDiscordMessage(diff));
        }
        this.inventoryItems = Collections.emptyList();
    }

    private String createDiscordMessage(List<SimpleItem> diffList) {
        Object message = "";
        String username = this.client.getLocalPlayer().getName();
        message = (String)message + username + " banked\n```diff\n";
        for (int i = 0; i < diffList.size(); ++i) {
            message = diffList.get(i).getQuantity() > 0 ? (String)message + "- " : (String)message + "+ ";
            ItemComposition composition = this.itemManager.getItemComposition(diffList.get(i).getItemId());
            message = (String)message + composition.getName() + " x " + Math.abs(diffList.get(i).getQuantity());
            message = (String)message + "\n";
        }
        message = (String)message + "```";
        return message;
    }

    private List<SimpleItem> getDiff(List<SimpleItem> before, List<SimpleItem> after) {
        HashMap<Integer, Integer> beforeItems = new HashMap<Integer, Integer>();
        HashMap afterItems = new HashMap();
        after.forEach(i -> afterItems.put(i.getItemId(), i.getQuantity()));
        ArrayList<SimpleItem> results = new ArrayList<SimpleItem>();
        for (SimpleItem i2 : before) {
            beforeItems.put(i2.getItemId(), i2.getQuantity());
            int diff = afterItems.getOrDefault(i2.getItemId(), 0) - i2.getQuantity();
            if (diff == 0) continue;
            results.add(new SimpleItem(i2.getItemId(), diff));
        }
        for (SimpleItem i2 : after) {
            if (beforeItems.containsKey(i2.getItemId())) continue;
            results.add(i2);
        }
        return results;
    }

    private List<SimpleItem> canonicalizeItemList(List<SimpleItem> itemList) {
        ArrayList<SimpleItem> canonList = new ArrayList<SimpleItem>();
        for (int i = 0; i < itemList.size(); ++i) {
            int canonId = this.itemManager.canonicalize(itemList.get(i).getItemId());
            boolean add = true;
            for (int j = 0; j < canonList.size(); ++j) {
                if (((SimpleItem)canonList.get(j)).getItemId() != canonId) continue;
                add = false;
                int before = ((SimpleItem)canonList.get(j)).getQuantity();
                canonList.remove(j);
                canonList.add(new SimpleItem(canonId, itemList.get(i).getQuantity() + before));
            }
            if (!add) continue;
            canonList.add(new SimpleItem(canonId, itemList.get(i).getQuantity()));
        }
        return canonList;
    }

    private List<SimpleItem> getItemsFromContainer(ItemContainer storage) {
        Item[] items = storage.getItems();
        if (items.length == 0) {
            return new ArrayList<SimpleItem>();
        }
        List<Object> itemList = Arrays.asList(items);
        if (itemList.size() == 28) {
            itemList = itemList.stream().filter(p -> p.getId() > -1).collect(Collectors.toList());
        }
        if (itemList.size() == 0) {
            return new ArrayList<SimpleItem>();
        }
        items = new Item[itemList.size()];
        itemList.toArray(items);
        Arrays.sort(items, new Comparator<Item>(){

            @Override
            public int compare(Item b1, Item b2) {
                if (b1.getId() > b2.getId()) {
                    return 1;
                }
                if (b1.getId() < b2.getId()) {
                    return -1;
                }
                return 0;
            }
        });
        ArrayList<SimpleItem> containerItems = new ArrayList<SimpleItem>();
        for (int i = 0; i < items.length; ++i) {
            ItemComposition composition = this.itemManager.getItemComposition(items[i].getId());
            Item[] finalItems = items;
            int finalI = i;
            boolean alreadyIn = containerItems.stream().anyMatch(o -> o.getItemId() == finalItems[finalI].getId());
            if (alreadyIn) {
                for (int j = 0; j < containerItems.size(); ++j) {
                    if (((SimpleItem)containerItems.get(j)).getItemId() != items[i].getId()) continue;
                    int count = ((SimpleItem)containerItems.get(j)).getQuantity();
                    containerItems.remove(j);
                    containerItems.add(new SimpleItem(composition.getId(), count + items[i].getQuantity()));
                }
                continue;
            }
            containerItems.add(new SimpleItem(composition.getId(), items[i].getQuantity()));
        }
        return containerItems;
    }

    private void sendDiscordMessage(String message) {
        if (this.config.webhook().trim().isEmpty()) {
            log.warn("Missing Discord webhook. Cannot send message.");
            return;
        }
        DiscordWebhookBody discordWebhookBody = new DiscordWebhookBody();
        discordWebhookBody.setContent(message);
        HttpUrl url = HttpUrl.parse((String)this.config.webhook().trim());
        MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("payload_json", RuneLiteAPI.GSON.toJson((Object)discordWebhookBody));
        MultipartBody requestBody = requestBodyBuilder.build();
        Request request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.error("Error submitting message to Discord webhook.", (Throwable)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                log.info("Successfully sent message to Discord.");
                response.close();
            }
        });
    }

    @Provides
    GimBankDiscordConfig provideConfig(ConfigManager configManager) {
        return (GimBankDiscordConfig)configManager.getConfig(GimBankDiscordConfig.class);
    }
}

