/*
 * Decompiled with CFR 0.152.
 */
package com.salverrs.HouseAdvertisementPlus;

import com.google.inject.Provides;
import com.salverrs.HouseAdvertisementPlus.AdvertUtil;
import com.salverrs.HouseAdvertisementPlus.HouseAdvertisement;
import com.salverrs.HouseAdvertisementPlus.HouseAdvertisementMapper;
import com.salverrs.HouseAdvertisementPlus.HouseAdvertisementPlusConfig;
import com.salverrs.HouseAdvertisementPlus.HouseAdvertisementPlusOverlay;
import com.salverrs.HouseAdvertisementPlus.WidgetTarget;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.VarClientStrChanged;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.menus.MenuManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="House Advertisement Plus", description="QOL features for the House Advertisement board.", tags={"poh", "house", "advert", "advertisement", "plus", "board", "favourites", "filter", "qol"}, enabledByDefault=true)
public class HouseAdvertisementPlusPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(HouseAdvertisementPlusPlugin.class);
    public static final String ConfigGroup = "HouseAdvertisementPlus";
    private String lastVisited = "";
    private Widget container;
    private boolean advertBoardVisible = false;
    private boolean shouldRenderBoard = false;
    private boolean shouldRenderHighlights = false;
    private boolean requiresUpdate = true;
    private List<String> favouritePlayers = new ArrayList<String>();
    private List<String> blacklistPlayers = new ArrayList<String>();
    private HashMap<String, HouseAdvertisement> adverts;
    private final List<WidgetTarget> widgetsToHighlight = new ArrayList<WidgetTarget>();
    private final List<WidgetTarget> textToHighlight = new ArrayList<WidgetTarget>();
    private final HashMap<String, Integer> defaultTextColours = new HashMap();
    @Inject
    private ClientThread clientThread;
    @Inject
    private Client client;
    @Inject
    private HouseAdvertisementPlusOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private MenuManager menuManager;
    @Inject
    private HouseAdvertisementPlusConfig config;

    protected void startUp() throws Exception {
        log.info("House Advertisement Plus started!");
        this.favouritePlayers = AdvertUtil.normalizeNames(Text.fromCSV((String)this.config.getPlayerFavourites()));
        this.blacklistPlayers = AdvertUtil.normalizeNames(Text.fromCSV((String)this.config.getPlayerBlacklist()));
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        log.info("House Advertisement Plus stopped!");
        this.resetAll();
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe(priority=-100.0f)
    public void onClientTick(ClientTick clientTick) {
        if (this.advertBoardVisible && this.requiresUpdate) {
            this.processHouseAdvertisements();
            this.requiresUpdate = false;
        }
        this.AddMenuEntries();
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        int id = event.getScriptId();
        if (id == 3110 || id == 3112 || id == 3109 || id == 3113) {
            this.resetUpdateState();
        }
    }

    @Subscribe
    public void onWidgetClosed(WidgetClosed e) {
        int groupId = e.getGroupId();
        if (groupId == 52) {
            this.advertBoardVisible = false;
            this.resetUpdateState();
            this.resetWidgetHighlights();
            this.refreshVisibility();
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded e) {
        int groupId = e.getGroupId();
        if (groupId == 52) {
            if (!this.isHouseAdvertWidgetVisible()) {
                return;
            }
            this.advertBoardVisible = true;
            this.resetUpdateState();
            this.refreshVisibility();
        }
    }

    @Subscribe
    public void onVarClientStrChanged(VarClientStrChanged e) {
        if (e.getIndex() == 361) {
            this.lastVisited = this.client.getVarcStrValue(361);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN) {
            this.lastVisited = this.client.getVarcStrValue(361);
        }
    }

    private void AddMenuEntries() {
        MenuEntry[] entries;
        if (this.client.getGameState() != GameState.LOGGED_IN || this.client.isMenuOpen()) {
            return;
        }
        for (MenuEntry entry : entries = this.client.getMenuEntries()) {
            String option = entry.getOption();
            if (this.advertBoardVisible && option.contains("Enter House")) {
                this.addCustomMenuOptions(entry);
                continue;
            }
            if (!option.contains("Visit-Last") || !this.config.visitLastPreview()) continue;
            this.addLastVisitName(entry);
        }
    }

    private void addCustomMenuOptions(MenuEntry entry) {
        Widget arrowWidget = entry.getWidget();
        if (arrowWidget.getOpacity() == 255) {
            this.client.setMenuEntries(new MenuEntry[0]);
            return;
        }
        String playerName = AdvertUtil.getPlayerFromOpArg(arrowWidget, 1);
        if (playerName == null || playerName.equals("")) {
            return;
        }
        String originalName = playerName;
        playerName = AdvertUtil.normalizeName(playerName);
        int menuInsertIndex = 2;
        if (this.config.useFavourites()) {
            if (this.favouritePlayers.contains(playerName)) {
                this.client.createMenuEntry(menuInsertIndex).setOption("Remove " + originalName + " from favourites").setTarget("").setType(MenuAction.RUNELITE).onClick(this.removeFromFavourites(playerName));
            } else {
                this.client.createMenuEntry(menuInsertIndex).setOption("Add " + originalName + " to favourites").setTarget("").setType(MenuAction.RUNELITE).onClick(this.addToFavourites(playerName));
            }
            --menuInsertIndex;
        }
        if (this.config.useBlacklist() && !this.favouritePlayers.contains(playerName)) {
            this.client.createMenuEntry(menuInsertIndex).setOption("Hide " + originalName).setTarget("").setType(MenuAction.RUNELITE).onClick(this.addToBlacklist(playerName));
        }
    }

    private void addLastVisitName(MenuEntry entry) {
        if (this.lastVisited != null && !this.lastVisited.equals("")) {
            int r = this.config.visitLastPreviewColour().getRed();
            int g = this.config.visitLastPreviewColour().getGreen();
            int b = this.config.visitLastPreviewColour().getBlue();
            String hexColor = String.format("%02x%02x%02x", r, g, b);
            entry.setTarget("<col=" + hexColor + ">" + this.lastVisited + "</col>");
        }
    }

    private Consumer<MenuEntry> addToBlacklist(String playerName) {
        return e -> {
            if (this.blacklistPlayers.contains(playerName)) {
                return;
            }
            ArrayList<String> newPlayerList = new ArrayList<String>(this.blacklistPlayers);
            newPlayerList.add(playerName);
            this.config.setPlayerBlacklist(Text.toCSV(newPlayerList));
            this.resetUpdateState();
        };
    }

    private Consumer<MenuEntry> addToFavourites(String playerName) {
        return e -> {
            if (this.favouritePlayers.contains(playerName)) {
                return;
            }
            ArrayList<String> newPlayerList = new ArrayList<String>(this.favouritePlayers);
            newPlayerList.add(playerName);
            this.config.setPlayerFavourites(Text.toCSV(newPlayerList));
            this.resetUpdateState();
        };
    }

    private Consumer<MenuEntry> removeFromFavourites(String playerName) {
        return e -> {
            if (!this.favouritePlayers.contains(playerName)) {
                return;
            }
            ArrayList<String> newPlayerList = new ArrayList<String>(this.favouritePlayers);
            newPlayerList.removeIf(p -> p.equals(playerName));
            this.config.setPlayerFavourites(Text.toCSV(newPlayerList));
            this.resetUpdateState();
        };
    }

    private void processHouseAdvertisements() {
        this.clientThread.invoke(() -> {
            this.resetWidgetHighlights();
            HouseAdvertisementMapper mapper = new HouseAdvertisementMapper(this.client, this.favouritePlayers, this.blacklistPlayers);
            this.adverts = mapper.GetHouseAdvertisements();
            if (this.adverts == null || this.adverts.size() == 0) {
                return;
            }
            ArrayList<HouseAdvertisement> ads = new ArrayList<HouseAdvertisement>(this.adverts.values());
            this.refreshAdvertState(ads);
            if (this.config.useBlacklist()) {
                this.applyBlacklist(this.adverts);
            }
            if (this.config.useFilters()) {
                this.applyFilters(ads);
            }
            if (this.config.useFavourites()) {
                if (this.config.pinFavourites()) {
                    this.moveFavouritesToTop(ads);
                }
                if (this.config.highlightEnterButton() || this.config.highlightAdvertText()) {
                    this.highlightFavourites(ads);
                }
            }
            this.moveInvisibleToBottom(ads);
            this.shouldRenderBoard = true;
        });
        this.clientThread.invokeLater(() -> this.refreshVisibility());
    }

    private void resetAll() {
        if (this.adverts != null) {
            this.refreshAdvertState(this.adverts.values());
        }
        this.shouldRenderBoard = true;
        this.refreshVisibility();
        this.resetWidgetHighlights();
        this.resetUpdateState();
    }

    private void resetUpdateState() {
        this.requiresUpdate = true;
        this.shouldRenderBoard = false;
        this.shouldRenderHighlights = false;
    }

    private void refreshAdvertState(Collection<HouseAdvertisement> ads) {
        for (HouseAdvertisement advert : ads) {
            if (advert == null) continue;
            advert.setIsVisible(true);
        }
    }

    private void refreshVisibility() {
        this.container = this.client.getWidget(52, 7);
        if (this.container == null) {
            return;
        }
        this.container.setType(this.shouldRenderBoard ? 0 : -1);
        this.shouldRenderHighlights = this.shouldRenderBoard;
    }

    private void resetWidgetHighlights() {
        for (WidgetTarget wt : this.textToHighlight) {
            Widget w = wt.getWidget();
            w.setTextColor(this.defaultTextColours.get(wt.getKey()).intValue());
        }
        this.widgetsToHighlight.clear();
        this.textToHighlight.clear();
    }

    private void applyBlacklist(HashMap<String, HouseAdvertisement> ads) {
        for (String playerName : ads.keySet()) {
            HouseAdvertisement advert = ads.get(playerName);
            if (!advert.isBlacklisted()) continue;
            advert.setIsVisible(false);
        }
    }

    private void applyFilters(List<HouseAdvertisement> ads) {
        for (HouseAdvertisement advert : ads) {
            if (this.passesFilter(advert)) continue;
            advert.setIsVisible(false);
        }
    }

    private boolean passesFilter(HouseAdvertisement advert) {
        return advert.getConstructionLvl() >= this.config.minConstructionLvl() && AdvertUtil.yesNoPasses(this.config.hasGuildedAltar(), advert.isHasGuildedAlter()) && advert.getNexusLvl() >= this.config.minNexusLvl() && advert.getJewelleryLvl() >= this.config.minJewelleryLvl() && advert.getPoolLvl() >= this.config.minPoolLvl() && advert.getSpellAltarLvl() >= this.config.minSpellAltarLvl() && AdvertUtil.yesNoPasses(this.config.hasArmourStand(), advert.isHasArmourStand());
    }

    private void moveInvisibleToBottom(List<HouseAdvertisement> ads) {
        ads.sort(Comparator.comparing(a -> !a.isVisible()));
        this.revalidateRowOrder(ads);
    }

    private void moveFavouritesToTop(List<HouseAdvertisement> ads) {
        ads.sort(Comparator.comparing(a -> -a.getFavouritePriority()));
        this.revalidateRowOrder(ads);
    }

    private void revalidateRowOrder(List<HouseAdvertisement> adverts) {
        for (int i = 0; i < adverts.size(); ++i) {
            HouseAdvertisement advert = adverts.get(i);
            advert.setRow(i);
        }
    }

    private void highlightFavourites(List<HouseAdvertisement> adverts) {
        for (HouseAdvertisement advert : adverts) {
            Widget enterArrow;
            if (!advert.isFavourite() || !advert.isVisible()) continue;
            if (this.config.highlightEnterButton() && (enterArrow = advert.getWidget("ENTER")) != null) {
                this.widgetsToHighlight.add(new WidgetTarget("ENTER", enterArrow));
            }
            if (!this.config.highlightAdvertText()) continue;
            for (String key : advert.getAdvertWidgets().keySet()) {
                if (key == "ENTER") continue;
                Widget w = advert.getWidget(key);
                this.textToHighlight.add(new WidgetTarget(key, w));
                if (this.defaultTextColours.containsKey(key)) continue;
                this.defaultTextColours.put(key, w.getTextColor());
            }
        }
    }

    private boolean isHouseAdvertWidgetVisible() {
        Widget titleParent = this.client.getWidget(52, 3);
        Widget title = titleParent != null ? titleParent.getChild(1) : null;
        String titleText = title != null ? title.getText() : null;
        return titleText != null && titleText.equals("House Advertisement");
    }

    public void renderHighlights(Graphics2D g) {
        if (!this.advertBoardVisible || !this.shouldRenderHighlights) {
            return;
        }
        Color highlightColor = this.config.highlightColor();
        for (WidgetTarget wt : this.widgetsToHighlight) {
            Rectangle bounds = wt.getWidget().getBounds();
            int adjustedWidth = bounds.width - bounds.width / 20;
            RoundRectangle2D.Double rounded = new RoundRectangle2D.Double(bounds.x, bounds.y, adjustedWidth, bounds.height, bounds.width / 5, bounds.width / 5);
            Area roundedArea = new Area(rounded);
            if (this.container != null) {
                Area containerArea = new Area(this.container.getBounds());
                roundedArea.intersect(containerArea);
            }
            g.setColor(highlightColor);
            g.draw(roundedArea);
        }
        for (WidgetTarget wt : this.textToHighlight) {
            wt.getWidget().setTextColor(highlightColor.getRGB());
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals(ConfigGroup)) {
            return;
        }
        this.favouritePlayers = AdvertUtil.normalizeNames(Text.fromCSV((String)this.config.getPlayerFavourites()));
        this.blacklistPlayers = AdvertUtil.normalizeNames(Text.fromCSV((String)this.config.getPlayerBlacklist()));
        this.resetUpdateState();
    }

    @Provides
    HouseAdvertisementPlusConfig provideConfig(ConfigManager configManager) {
        return (HouseAdvertisementPlusConfig)configManager.getConfig(HouseAdvertisementPlusConfig.class);
    }
}

