/*
 * Decompiled with CFR 0.152.
 */
package com.salverrs.HouseAdvertisementPlus;

import com.salverrs.HouseAdvertisementPlus.Filters.YesNoFilter;
import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;

@ConfigGroup(value="HouseAdvertisementPlus")
public interface HouseAdvertisementPlusConfig
extends Config {
    @ConfigSection(name="Filters", description="House advertisement filters.", position=0)
    public static final String filtersSection = "filters";
    @ConfigSection(name="Favourites", description="Favourite house advertisements.", position=1)
    public static final String favouritesSection = "favourites";
    @ConfigSection(name="Blacklist", description="House advertisements to always hide.", position=2)
    public static final String blackListSection = "blacklist";
    @ConfigSection(name="Menu Options", description="House Advertisement menu options.", position=3)
    public static final String menuOptionsSection = "menuOptions";

    @ConfigItem(keyName="useAdvertFilters", name="Enable Filters", description="Enable the filters feature for the advertisement board.", position=0, section="filters")
    default public boolean useFilters() {
        return false;
    }

    @Range(max=99, min=0)
    @ConfigItem(keyName="minConstructionLvl", name="Minimum Construction Level", description="The minimum Construction level for a house advertisement to be shown.", position=1, section="filters")
    default public int minConstructionLvl() {
        return 1;
    }

    @ConfigItem(keyName="hasGuildedAltar", name="Has Guilded Altar", description="The minimum Guilded Altar requirement for a house advertisement to be shown.", position=2, section="filters")
    default public YesNoFilter hasGuildedAltar() {
        return YesNoFilter.N;
    }

    @Range(max=3, min=0)
    @ConfigItem(keyName="minNexusLvl", name="Minimum Nexus Tier", description="The minimum Nexus tier for a house advertisement to be shown.", position=3, section="filters")
    default public int minNexusLvl() {
        return 0;
    }

    @Range(max=3, min=0)
    @ConfigItem(keyName="minJewelleryLvl", name="Minimum Jewellery Box Tier", description="The minimum Jewellery Box tier for a house advertisement to be shown.", position=4, section="filters")
    default public int minJewelleryLvl() {
        return 0;
    }

    @Range(max=5, min=0)
    @ConfigItem(keyName="minPoolLvl", name="Minimum Pool Tier", description="The minimum Pool tier for a house advertisement to be shown.", position=5, section="filters")
    default public int minPoolLvl() {
        return 0;
    }

    @Range(max=4, min=0)
    @ConfigItem(keyName="minSpellAltarLvl", name="Minimum Spell Altar Tier", description="The minimum Spell Altar tier for a house advertisement to be shown.", position=6, section="filters")
    default public int minSpellAltarLvl() {
        return 0;
    }

    @ConfigItem(keyName="hasArmourStand", name="Has Armour Stand", description="The minimum Armour Stand requirement for a house advertisement to be shown.", position=7, section="filters")
    default public YesNoFilter hasArmourStand() {
        return YesNoFilter.N;
    }

    @ConfigItem(keyName="useFavourites", name="Enable Favourites", description="Enable the favourites feature for house advertisements.", position=8, section="favourites")
    default public boolean useFavourites() {
        return true;
    }

    @ConfigItem(keyName="favouritePlayers", name="Favourite Players", description="List of favourite player house advertisements (Comma separated). These can also be added by right-clicking the arrow on advertisements.", position=9, section="favourites")
    default public String getPlayerFavourites() {
        return "";
    }

    @ConfigItem(keyName="favouritePlayers", name="", description="")
    public void setPlayerFavourites(String var1);

    @ConfigItem(keyName="pinFavourites", name="Pin Favourites to Top", description="Pin favourites to the top of the advertisement board.", position=10, section="favourites")
    default public boolean pinFavourites() {
        return true;
    }

    @ConfigItem(keyName="highlightColor", name="Highlight Colour", description="The highlight colour for advertisement favorites.", position=11, section="favourites")
    default public Color highlightColor() {
        return new Color(255, 255, 0);
    }

    @ConfigItem(keyName="highlightEnterButton", name="Highlight Advert Enter Button", description="Highlight the advertisement arrow button used to enter the house.", position=12, section="favourites")
    default public boolean highlightEnterButton() {
        return true;
    }

    @ConfigItem(keyName="highlightEntireAdvert", name="Highlight Advert Text", description="Highlight the text on the advertisement row.", position=13, section="favourites")
    default public boolean highlightAdvertText() {
        return true;
    }

    @ConfigItem(keyName="useBlacklist", name="Enable Blacklist", description="Enable the blacklist feature for house advertisements.", position=14, section="blacklist")
    default public boolean useBlacklist() {
        return true;
    }

    @ConfigItem(keyName="blacklistedPlayers", name="Blacklisted Players (Hidden)", description="List of blacklisted player house advertisements to hide (Comma separated). These can also be added by right-clicking the arrow on advertisements.", position=15, section="blacklist")
    default public String getPlayerBlacklist() {
        return "";
    }

    @ConfigItem(keyName="blacklistedPlayers", name="", description="")
    public void setPlayerBlacklist(String var1);

    @ConfigItem(keyName="visitLastPreview", name="Show Visit-Last Name Preview", description="Preview the name of the last house you visited on the Visit-Last menu option (when available).", position=16, section="menuOptions")
    default public boolean visitLastPreview() {
        return true;
    }

    @ConfigItem(keyName="visitLastPreviewColour", name="Name Preview Colour", description="The colour of the Visit-Last name preview (when available).", position=17, section="menuOptions")
    default public Color visitLastPreviewColour() {
        return new Color(0, 255, 0);
    }
}

