/*
 * Decompiled with CFR 0.152.
 */
package com.salverrs.HouseAdvertisementPlus;

import com.salverrs.HouseAdvertisementPlus.AdvertUtil;
import com.salverrs.HouseAdvertisementPlus.HouseAdvertisement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import org.apache.commons.lang3.BooleanUtils;

public class HouseAdvertisementMapper {
    private Client client;
    private List<String> favourites;
    private List<String> blacklist;

    public HouseAdvertisementMapper(Client client, List<String> favourites, List<String> blacklist) {
        this.favourites = favourites;
        this.client = client;
        this.blacklist = blacklist;
    }

    public HashMap<String, HouseAdvertisement> GetHouseAdvertisements() {
        String text;
        HouseAdvertisement advert;
        Widget root = this.client.getWidget(52, 0);
        if (root == null) {
            return null;
        }
        HashMap<Integer, HouseAdvertisement> advertYOffsetMap = new HashMap<Integer, HouseAdvertisement>();
        HashMap<String, HouseAdvertisement> advertPlayerNameMap = new HashMap<String, HouseAdvertisement>();
        Widget[] playerNameWidgets = this.client.getWidget(52, 9).getDynamicChildren();
        Widget[] constructionLvlWidgets = this.client.getWidget(52, 12).getDynamicChildren();
        Widget[] guildedAlterWidgets = this.client.getWidget(52, 13).getDynamicChildren();
        Widget[] nexusLvlWidgets = this.client.getWidget(52, 14).getDynamicChildren();
        Widget[] jewelleryLvlWidgets = this.client.getWidget(52, 15).getDynamicChildren();
        Widget[] poolLvlWidgets = this.client.getWidget(52, 16).getDynamicChildren();
        Widget[] spellAltarLvlWidgets = this.client.getWidget(52, 17).getDynamicChildren();
        Widget[] armourStandWidgets = this.client.getWidget(52, 18).getDynamicChildren();
        Widget[] enterArrowWidgets = this.client.getWidget(52, 19).getDynamicChildren();
        Widget[] locationNameWidgets = this.client.getWidget(52, 10).getDynamicChildren();
        for (Widget w : playerNameWidgets) {
            if (w.isHidden()) continue;
            String playerName = AdvertUtil.normalizeName(w.getText());
            int yOffset = w.getRelativeY();
            if (playerName == null || playerName == "") continue;
            advert = new HouseAdvertisement(playerName, yOffset);
            advert.setOriginalYOffset(yOffset);
            advert.addWidget("NAME", w);
            advertYOffsetMap.put(yOffset, advert);
            advertPlayerNameMap.put(playerName, advert);
            if (this.favourites.contains(playerName)) {
                advert.setFavourite(true);
                advert.setFavouritePriority(this.getFavouriteIndex(playerName));
            } else {
                advert.setFavouritePriority(-1);
            }
            if (!this.blacklist.contains(playerName)) continue;
            advert.setBlacklisted(true);
        }
        for (Widget w : constructionLvlWidgets) {
            int yOffset;
            HouseAdvertisement advert2;
            if (w.isHidden() || (advert2 = (HouseAdvertisement)advertYOffsetMap.get(yOffset = w.getRelativeY())) == null || (text = w.getText()) == null || text.equals("")) continue;
            int constructionLvl = Integer.parseInt(text);
            advert2.setConstructionLvl(constructionLvl);
            advert2.addWidget("CONSTRUCTION", w);
        }
        for (Widget w : guildedAlterWidgets) {
            int yOffset;
            HouseAdvertisement advert3;
            if (w.isHidden() || (advert3 = (HouseAdvertisement)advertYOffsetMap.get(yOffset = w.getRelativeY())) == null || (text = w.getText()) == null || text.equals("")) continue;
            boolean hasGuildedAlter = BooleanUtils.toBoolean((String)text);
            advert3.setHasGuildedAlter(hasGuildedAlter);
            advert3.addWidget("ALTAR", w);
        }
        for (Widget w : nexusLvlWidgets) {
            int yOffset;
            HouseAdvertisement advert4;
            if (w.isHidden() || (advert4 = (HouseAdvertisement)advertYOffsetMap.get(yOffset = w.getRelativeY())) == null || (text = w.getText()) == null || text.equals("")) continue;
            int nexusLvl = Integer.parseInt(text);
            advert4.setNexusLvl(nexusLvl);
            advert4.addWidget("NEXUS", w);
        }
        for (Widget w : jewelleryLvlWidgets) {
            int yOffset;
            HouseAdvertisement advert5;
            if (w.isHidden() || (advert5 = (HouseAdvertisement)advertYOffsetMap.get(yOffset = w.getRelativeY())) == null || (text = w.getText()) == null || text.equals("")) continue;
            int jewelleryLvl = Integer.parseInt(text);
            advert5.setJewelleryLvl(jewelleryLvl);
            advert5.addWidget("JEWELLERY", w);
        }
        for (Widget w : poolLvlWidgets) {
            int yOffset;
            HouseAdvertisement advert6;
            if (w.isHidden() || (advert6 = (HouseAdvertisement)advertYOffsetMap.get(yOffset = w.getRelativeY())) == null || (text = w.getText()) == null || text.equals("")) continue;
            int poolLvl = Integer.parseInt(text);
            advert6.setPoolLvl(poolLvl);
            advert6.addWidget("POOL", w);
        }
        for (Widget w : spellAltarLvlWidgets) {
            int yOffset;
            HouseAdvertisement advert7;
            if (w.isHidden() || (advert7 = (HouseAdvertisement)advertYOffsetMap.get(yOffset = w.getRelativeY())) == null || (text = w.getText()) == null || text.equals("")) continue;
            int spellAltarLvl = Integer.parseInt(text);
            advert7.setSpellAltarLvl(spellAltarLvl);
            advert7.addWidget("SPELL_ALTAR", w);
        }
        for (Widget w : armourStandWidgets) {
            int yOffset;
            HouseAdvertisement advert8;
            if (w.isHidden() || (advert8 = (HouseAdvertisement)advertYOffsetMap.get(yOffset = w.getRelativeY())) == null || (text = w.getText()) == null || text.equals("")) continue;
            boolean hasArmourStand = BooleanUtils.toBoolean((String)text);
            advert8.setHasArmourStand(hasArmourStand);
            advert8.addWidget("ARMOUR_STAND", w);
        }
        for (Widget w : enterArrowWidgets) {
            String playerName;
            String nameArg;
            if (w.isHidden() || (nameArg = AdvertUtil.getPlayerFromOpArg(w, 1)) == null || nameArg.equals("") || (advert = (HouseAdvertisement)advertPlayerNameMap.get(playerName = AdvertUtil.normalizeName(nameArg))) == null) continue;
            advert.setAnotherLocation(false);
            advert.addWidget("ENTER", w);
        }
        for (Widget w : locationNameWidgets) {
            int yOffset;
            HouseAdvertisement advert9;
            if (w.isHidden() || (advert9 = (HouseAdvertisement)advertYOffsetMap.get(yOffset = w.getRelativeY())) == null || (text = w.getText()) == null || text.equals("")) continue;
            advert9.setLocation(text);
            advert9.addWidget("LOCATION", w);
        }
        ArrayList adverts = new ArrayList(advertPlayerNameMap.values());
        adverts.sort(Comparator.comparing(a -> a.getOriginalYOffset()));
        for (int i = 0; i < adverts.size(); ++i) {
            HouseAdvertisement advert10 = (HouseAdvertisement)adverts.get(i);
            advert10.setRowIndex(i);
        }
        return advertPlayerNameMap;
    }

    private int getFavouriteIndex(String playerName) {
        int index = this.favourites.indexOf(AdvertUtil.normalizeName(playerName));
        if (index == -1) {
            return index;
        }
        return this.favourites.size() - index;
    }
}

