/*
 * Decompiled with CFR 0.152.
 */
package com.salverrs.HouseAdvertisementPlus;

import java.util.HashMap;
import net.runelite.api.widgets.Widget;

public class HouseAdvertisement {
    private int originalYOffset;
    private int rowIndex;
    private int favouritePriority;
    private String playerName;
    private String location;
    private int constructionLvl;
    private boolean hasGuildedAlter;
    private int nexusLvl;
    private int jewelleryLvl;
    private int poolLvl;
    private int spellAltarLvl;
    private boolean hasArmourStand;
    private boolean isFavourite;
    private boolean isBlacklisted;
    private boolean isAnotherLocation;
    private boolean isVisible;
    private HashMap<String, Widget> advertWidgets;

    public HouseAdvertisement(String playerName, int yOffset) {
        this.playerName = playerName;
        this.advertWidgets = new HashMap();
        this.isAnotherLocation = true;
    }

    public void addWidget(String key, Widget w) {
        this.advertWidgets.put(key, w);
    }

    public Widget getWidget(String key) {
        return this.advertWidgets.get(key);
    }

    public void setIsVisible(boolean visible) {
        this.isVisible = visible;
        for (Widget w : this.advertWidgets.values()) {
            w.setOpacity(visible ? 0 : 255);
            w.setFontId(visible ? 495 : -1);
        }
    }

    public void setRow(int targetRowIndex) {
        for (String widgetKey : this.advertWidgets.keySet()) {
            Widget widget = this.advertWidgets.get(widgetKey);
            int height = widget.getHeight();
            int relativeY = widget.getRelativeY();
            if (widgetKey == "ENTER") {
                int numPadding = this.rowIndex * 2 + 1;
                int paddingHeight = (relativeY - height * this.rowIndex) / numPadding;
                int targetNumPadding = targetRowIndex * 2 + 1;
                int targetYOffset = targetRowIndex * height + targetNumPadding * paddingHeight;
                widget.setOriginalY(targetYOffset);
            } else {
                int targetYOffset = targetRowIndex * widget.getHeight();
                widget.setOriginalY(targetYOffset);
            }
            widget.revalidate();
        }
        this.rowIndex = targetRowIndex;
    }

    public int getOriginalYOffset() {
        return this.originalYOffset;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getFavouritePriority() {
        return this.favouritePriority;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public String getLocation() {
        return this.location;
    }

    public int getConstructionLvl() {
        return this.constructionLvl;
    }

    public boolean isHasGuildedAlter() {
        return this.hasGuildedAlter;
    }

    public int getNexusLvl() {
        return this.nexusLvl;
    }

    public int getJewelleryLvl() {
        return this.jewelleryLvl;
    }

    public int getPoolLvl() {
        return this.poolLvl;
    }

    public int getSpellAltarLvl() {
        return this.spellAltarLvl;
    }

    public boolean isHasArmourStand() {
        return this.hasArmourStand;
    }

    public boolean isFavourite() {
        return this.isFavourite;
    }

    public boolean isBlacklisted() {
        return this.isBlacklisted;
    }

    public boolean isAnotherLocation() {
        return this.isAnotherLocation;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public HashMap<String, Widget> getAdvertWidgets() {
        return this.advertWidgets;
    }

    public void setOriginalYOffset(int originalYOffset) {
        this.originalYOffset = originalYOffset;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public void setFavouritePriority(int favouritePriority) {
        this.favouritePriority = favouritePriority;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setConstructionLvl(int constructionLvl) {
        this.constructionLvl = constructionLvl;
    }

    public void setHasGuildedAlter(boolean hasGuildedAlter) {
        this.hasGuildedAlter = hasGuildedAlter;
    }

    public void setNexusLvl(int nexusLvl) {
        this.nexusLvl = nexusLvl;
    }

    public void setJewelleryLvl(int jewelleryLvl) {
        this.jewelleryLvl = jewelleryLvl;
    }

    public void setPoolLvl(int poolLvl) {
        this.poolLvl = poolLvl;
    }

    public void setSpellAltarLvl(int spellAltarLvl) {
        this.spellAltarLvl = spellAltarLvl;
    }

    public void setHasArmourStand(boolean hasArmourStand) {
        this.hasArmourStand = hasArmourStand;
    }

    public void setFavourite(boolean isFavourite) {
        this.isFavourite = isFavourite;
    }

    public void setBlacklisted(boolean isBlacklisted) {
        this.isBlacklisted = isBlacklisted;
    }

    public void setAnotherLocation(boolean isAnotherLocation) {
        this.isAnotherLocation = isAnotherLocation;
    }

    public void setAdvertWidgets(HashMap<String, Widget> advertWidgets) {
        this.advertWidgets = advertWidgets;
    }
}

