/*
 * Decompiled with CFR 0.152.
 */
package com.togglechat;

import com.google.inject.Provides;
import com.togglechat.ToggleChatConfig;
import java.awt.event.KeyEvent;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.Keybind;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Toggle Chat", description="Uses a hotkey to open/close chat", tags={"hotkey", "toggle", "chat"})
public class ToggleChatPlugin
extends Plugin
implements KeyListener {
    private static final Logger log = LoggerFactory.getLogger(ToggleChatPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ToggleChatConfig config;
    private boolean consumeKeys = false;

    @Provides
    ToggleChatConfig getConfig(ConfigManager configManager) {
        return (ToggleChatConfig)configManager.getConfig(ToggleChatConfig.class);
    }

    protected void startUp() {
        this.keyManager.registerKeyListener((KeyListener)this);
    }

    protected void shutDown() {
        this.keyManager.unregisterKeyListener((KeyListener)this);
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired event) {
        if (event.getScriptId() == 179) {
            if (!this.config.removeFlashingTabs()) {
                return;
            }
            if (this.config.notifyWithOpenChat() && !this.isChatClosed()) {
                return;
            }
            if (this.config.gameChat()) {
                this.client.setVarcIntValue(44, 0);
            }
            if (this.config.publicChat()) {
                this.client.setVarcIntValue(45, 0);
            }
            if (this.config.privateChat()) {
                this.client.setVarcIntValue(46, 0);
            }
            if (this.config.clanChat()) {
                this.client.setVarcIntValue(47, 0);
            }
            if (this.config.tradeChat()) {
                this.client.setVarcIntValue(48, 0);
            }
            if (this.config.channelChat()) {
                this.client.setVarcIntValue(438, 0);
            }
        }
    }

    public void keyTyped(KeyEvent e) {
        if (this.consumeKeys) {
            e.consume();
        }
    }

    public void keyPressed(KeyEvent e) {
        if (this.config.hotKey().matches(e)) {
            if (Keybind.getModifierForKeyCode((int)e.getKeyCode()) == null && e.getKeyCode() != 27) {
                this.consumeKeys = true;
                e.consume();
            }
            this.clientThread.invokeLater(() -> this.client.runScript(new Object[]{175, 1, this.isChatClosed() ? this.config.defaultTab().getTab() : this.getChatboxId()}));
        }
    }

    public void keyReleased(KeyEvent e) {
        if (this.config.hotKey().matches(e)) {
            this.consumeKeys = false;
        }
    }

    private boolean isChatClosed() {
        return this.client.getVarcIntValue(41) == 1337;
    }

    private int getChatboxId() {
        return this.client.getVarcIntValue(41);
    }
}

