/*
 * Decompiled with CFR 0.152.
 */
package com.patchpayment;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.inject.Provides;
import com.patchpayment.PatchPaymentConfig;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.MenuAction;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Patch Payment", description="Creates a menu item to check a seed's required payment.", tags={"farming", "payment"}, loadWhenOutdated=true, enabledByDefault=false)
public class PatchPaymentPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PatchPaymentPlugin.class);
    static final String CONFIG_GROUP = "patchpayment";
    static final String CHECK_EXAMINE = "examinetext";
    static final String CHECK_BANK = "bankmenuitem";
    static final String CHECK_VAULT = "seedvaultitem";
    private static final String CHECK_PAYMENT = "Check";
    private static final String EXAMINE = "Examine";
    private static final Map<Integer, PairInterface> payments;
    private final Set<Integer> acceptedWidgetIds = Sets.newHashSet();
    @Inject
    @Nullable
    private Client client;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private PatchPaymentConfig config;

    private static void add(ImmutableMap.Builder<Integer, PairInterface> builder, PairInterface response) {
        for (int id : response.getTargetItems()) {
            builder.put((Object)id, (Object)response);
        }
    }

    @Provides
    PatchPaymentConfig getConfig(ConfigManager configManager) {
        return (PatchPaymentConfig)configManager.getConfig(PatchPaymentConfig.class);
    }

    protected void startUp() {
        this.updateConfig();
    }

    protected void shutDown() {
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals(CONFIG_GROUP)) {
            return;
        }
        this.updateConfig();
    }

    private void updateConfig() {
        this.acceptedWidgetIds.clear();
        this.acceptedWidgetIds.add(WidgetInfo.INVENTORY.getId());
        if (this.config.checkInVault()) {
            this.acceptedWidgetIds.add(WidgetInfo.SEED_VAULT_ITEM_CONTAINER.getId());
            this.acceptedWidgetIds.add(WidgetInfo.SEED_VAULT_INVENTORY_ITEMS_CONTAINER.getId());
        }
        if (this.config.checkInBank()) {
            this.acceptedWidgetIds.add(WidgetInfo.BANK_ITEM_CONTAINER.getId());
            this.acceptedWidgetIds.add(WidgetInfo.BANK_INVENTORY_ITEMS_CONTAINER.getId());
        }
    }

    private void displayGameMessage(PairInterface pi, ItemComposition ic) {
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(pi.getMessage(ic)).build());
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getWidget() != null && this.config.checkWithExamine() && event.getMenuOption().equals(EXAMINE)) {
            int widgetId = event.getWidget().getId();
            if (!this.acceptedWidgetIds.contains(widgetId)) {
                return;
            }
            ItemComposition composition = this.client.getItemDefinition(event.getWidget().getItemId());
            int itemId = composition.getId();
            if (payments.containsKey(itemId)) {
                this.displayGameMessage(payments.get(itemId), composition);
            }
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (event.getMenuEntry().getWidget() != null && !this.config.checkWithExamine() && event.getOption().equals(EXAMINE)) {
            if (!this.acceptedWidgetIds.contains(event.getMenuEntry().getWidget().getId())) {
                return;
            }
            int itemId = event.getMenuEntry().getWidget().getItemId();
            if (payments.containsKey(itemId)) {
                ItemComposition ic = this.client.getItemDefinition(itemId);
                this.client.createMenuEntry(-1).setOption(CHECK_PAYMENT).setTarget(event.getTarget()).setType(MenuAction.RUNELITE).onClick(e -> this.displayGameMessage(payments.get(itemId), ic));
            }
        }
    }

    private static String stripAndShrink(String text) {
        return text.replace("seed", "").replace("sapling", "").replace("spore", "").toLowerCase().trim();
    }

    private static String grammatify(String text) {
        char[] vowels;
        for (char vowel : vowels = new char[]{'a', 'e', 'i', 'o', 'u'}) {
            if (text.toLowerCase().charAt(0) != vowel) continue;
            return "an";
        }
        return "a";
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("2 buckets of compost", new int[]{5318}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("1 full sack of potatoes", new int[]{5319}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("1 full sack of onions", new int[]{5324}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("2 full sacks of cabbages", new int[]{5322}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("10 jute fibres", new int[]{5320}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("1 full basket of apples", new int[]{5323}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("10 curry leaves", new int[]{5321}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("5 jangerberries", new int[]{22879}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new CustomPair(new int[]{5096, 5097, 5098, 5099, 5100, 22887}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new CustomPair(new int[]{5291, 5292, 5293, 5294, 6311, 5295, 5296, 5297, 5298, 5299, 5300, 5301, 5302, 5303, 5304}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("3 buckets of compost", new int[]{5305}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("1 marigold", new int[]{5307}, "hammerstone hops"));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("1 full sack of onions", new int[]{5308}, "asgarnian hops"));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("6 barley malts", new int[]{5306}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("1 full basket of tomatoes", new int[]{5309}, "yanillian hops"));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("3 full sacks of cabbages", new int[]{5310}, "krandorian hops"));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("1 nasturtium", new int[]{5311}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("4 full sacks of cabbages", new int[]{5101}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("3 full baskets of tomatoes", new int[]{5102}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("3 full baskets of strawberries", new int[]{5103}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("6 watermelons", new int[]{5104}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("8 bittercap mushrooms", new int[]{5105}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new CustomPair("as it will never get diseased", new int[]{5106}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("1 full basket of tomatoes", new int[]{5312, 5370, 5358, 5364}, "oak tree"));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("1 full basket of apples", new int[]{5313, 5371, 5359, 5365}, "willow tree"));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("1 full basket of oranges", new int[]{5314, 5372, 5360, 5366}, "maple tree"));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("10 cactus spines", new int[]{5315, 5373, 5361, 5367}, "yew tree"));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("25 coconuts", new int[]{5316, 5374, 5362, 5368}, "magic tree"));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("9 sweetcorn", new int[]{5283, 5496, 5480, 5488}, "apple tree"));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("4 full baskets of apples", new int[]{5284, 5497, 5481, 5489}, "banana tree"));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("3 full baskets of strawberries", new int[]{5285, 5498, 5482, 5490}, "orange tree"));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("5 full baskets of bananas", new int[]{5286, 5499, 5483, 5491}, "curry tree"));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("10 watermelons", new int[]{5287, 5500, 5484, 5492}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("10 pineapples", new int[]{5288, 5501, 5485, 5493}, "papaya tree"));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("15 papaya fruit", new int[]{5289, 5502, 5486, 5494}, "palm tree"));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("15 coconuts", new int[]{22877, 22866, 22862, 22864}, "dragonfruit tree"));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("200 numulite", new int[]{21490}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new CustomPair("as it is protected for free. That doesn't make sense but I'm too lazy to change it", new int[]{13657}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new CustomPair(new int[]{5282, 5281}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new CustomPair("as it is immune to disease", new int[]{22875}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new CustomPair(new int[]{22885, 22883, 22881}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("15 limpwurt roots", new int[]{21486, 21477, 21469, 21473}, "teak tree"));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("25 yanillian hops", new int[]{21488, 21480, 21471, 21475}, "mahogany tree"));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("8 poison ivy berries", new int[]{5290, 5503, 5487, 5495}, "calquat tree"));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new CustomPair("as it is immune to disease", new int[]{23808, 23659, 23655, 23657}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("5 monkey nuts, 1 monkey bar, and 1 ground tooth", new int[]{5317, 5375, 5363, 5369}, "spirit tree"));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("8 potato cacti", new int[]{22869, 22856, 22848, 22852}, "celastrus tree"));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("6 dragonfruit", new int[]{22871, 22859, 22850, 22854}, "redwood tree"));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("6 cadava berries", new int[]{5280}));
        PatchPaymentPlugin.add((ImmutableMap.Builder<Integer, PairInterface>)builder, new PaymentPair("8 snape grass", new int[]{22873}));
        payments = builder.build();
    }

    private static class CustomPair
    implements PairInterface {
        String message = "";
        int[] pairedIDs;
        String preferredName = null;

        public CustomPair(int[] pairedIDs) {
            this.pairedIDs = pairedIDs;
        }

        public CustomPair(String message, int[] pairedIDs) {
            this.message = " " + message;
            this.pairedIDs = pairedIDs;
        }

        @Override
        public int[] getTargetItems() {
            return this.pairedIDs;
        }

        @Override
        public String getMessage(ItemComposition ic) {
            String text = ic.getName();
            if (this.getPreferredName() != null) {
                text = this.getPreferredName();
            }
            return new ChatMessageBuilder().append(ChatColorType.NORMAL).append(PatchPaymentPlugin.grammatify(text).replace('a', 'A')).append(" ").append(ChatColorType.HIGHLIGHT).append(PatchPaymentPlugin.stripAndShrink(text)).append(ChatColorType.NORMAL).append(" patch can ").append(ChatColorType.HIGHLIGHT).append("NOT").append(ChatColorType.NORMAL).append(" be protected by a farmer").append(this.message).build();
        }

        public String getPreferredName() {
            return this.preferredName;
        }
    }

    static class PaymentPair
    implements PairInterface {
        String payment;
        int[] pairedIDs;
        String preferredName = null;

        public PaymentPair(String payment, int[] pairedIDs) {
            this.payment = payment;
            this.pairedIDs = pairedIDs;
        }

        public PaymentPair(String payment, int[] pairedIDs, String preferredName) {
            this(payment, pairedIDs);
            this.preferredName = preferredName;
        }

        @Override
        public int[] getTargetItems() {
            return this.pairedIDs;
        }

        @Override
        public String getMessage(ItemComposition ic) {
            String text = ic.getName();
            if (this.getPreferredName() != null) {
                text = this.getPreferredName();
            }
            return new ChatMessageBuilder().append(ChatColorType.NORMAL).append("A farmer will watch over ").append(PatchPaymentPlugin.grammatify(text)).append(" ").append(ChatColorType.HIGHLIGHT).append(PatchPaymentPlugin.stripAndShrink(text)).append(ChatColorType.NORMAL).append(" patch for ").append(ChatColorType.HIGHLIGHT).append(this.payment).build();
        }

        public String getPreferredName() {
            return this.preferredName;
        }
    }

    public static interface PairInterface {
        public int[] getTargetItems();

        public String getMessage(ItemComposition var1);
    }
}

