/*
 * Decompiled with CFR 0.152.
 */
package com.NativeMacNotifications.macJna;

import com.NativeMacNotifications.macJna.FoundationLibrary;
import com.NativeMacNotifications.macJna.ID;
import com.sun.jna.Function;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import java.lang.reflect.Proxy;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public final class Foundation {
    private static final FoundationLibrary myFoundationLibrary = (FoundationLibrary)Native.loadLibrary((String)"Foundation", FoundationLibrary.class);
    private static final Function myObjcMsgSend;

    public static void init() {
    }

    private Foundation() {
    }

    public static ID getObjcClass(String className) {
        return myFoundationLibrary.objc_getClass(className);
    }

    public static Pointer createSelector(String s) {
        return myFoundationLibrary.sel_registerName(s);
    }

    private static Object[] prepInvoke(ID id, Pointer selector, Object[] args) {
        Object[] invokArgs = new Object[args.length + 2];
        invokArgs[0] = id;
        invokArgs[1] = selector;
        System.arraycopy(args, 0, invokArgs, 2, args.length);
        return invokArgs;
    }

    public static ID invoke(ID id, Pointer selector, Object ... args) {
        return new ID(myObjcMsgSend.invokeLong(Foundation.prepInvoke(id, selector, args)));
    }

    public static ID invoke(String cls, String selector, Object ... args) {
        return Foundation.invoke(Foundation.getObjcClass(cls), Foundation.createSelector(selector), args);
    }

    public static ID invoke(ID id, String selector, Object ... args) {
        return Foundation.invoke(id, Foundation.createSelector(selector), args);
    }

    public static ID nsString(@Nullable String s) {
        return s == null ? ID.NIL : NSString.create(s);
    }

    private static long convertCFEncodingToNS(long cfEncoding) {
        return myFoundationLibrary.CFStringConvertEncodingToNSStringEncoding(cfEncoding) & 0xFFFFFFFFFFL;
    }

    static {
        NativeLibrary nativeLibrary = ((Library.Handler)Proxy.getInvocationHandler(myFoundationLibrary)).getNativeLibrary();
        myObjcMsgSend = nativeLibrary.getFunction("objc_msgSend");
    }

    private static final class NSString {
        private static final ID nsStringCls = Foundation.getObjcClass("NSString");
        private static final Pointer stringSel = Foundation.createSelector("string");
        private static final Pointer allocSel = Foundation.createSelector("alloc");
        private static final Pointer autoreleaseSel = Foundation.createSelector("autorelease");
        private static final Pointer initWithBytesLengthEncodingSel = Foundation.createSelector("initWithBytes:length:encoding:");
        private static final long nsEncodingUTF16LE = Foundation.convertCFEncodingToNS(0x14000100L);

        private NSString() {
        }

        public static ID create(String s) {
            if (s.isEmpty()) {
                return Foundation.invoke(nsStringCls, stringSel, new Object[0]);
            }
            byte[] utf16Bytes = s.getBytes(StandardCharsets.UTF_16LE);
            return Foundation.invoke(Foundation.invoke(Foundation.invoke(nsStringCls, allocSel, new Object[0]), initWithBytesLengthEncodingSel, utf16Bytes, utf16Bytes.length, nsEncodingUTF16LE), autoreleaseSel, new Object[0]);
        }
    }
}

