/*
 * Decompiled with CFR 0.152.
 */
package com.NativeMacNotifications;

import com.NativeMacNotifications.Notification;
import com.google.common.base.Strings;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.NotificationFired;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginInstantiationException;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.util.OSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Native Mac Notifications")
public class NativeMacNotificationsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NativeMacNotificationsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private RuneLiteConfig runeLiteConfig;
    @Inject
    private ClientUI clientUI;
    @Inject
    private ConfigManager configManager;
    private Boolean resetTrayNotificationsAtShutDown = false;

    @Subscribe
    public void onNotificationFired(NotificationFired notificationFired) {
        try {
            if (OSType.getOSType() != OSType.MacOS) {
                return;
            }
            if (!this.runeLiteConfig.sendNotificationsWhenFocused() && this.clientUI.isFocused()) {
                return;
            }
            Notification.notify(this.buildTitle(), notificationFired.getMessage());
        }
        catch (Exception e) {
            this.stopPlugin();
        }
    }

    protected void startUp() {
        if (OSType.getOSType() == OSType.MacOS && this.runeLiteConfig.enableTrayNotifications()) {
            this.resetTrayNotificationsAtShutDown = true;
            this.setNotificationTray(false);
        }
    }

    protected void shutDown() {
        if (this.resetTrayNotificationsAtShutDown.booleanValue()) {
            this.setNotificationTray(true);
        }
    }

    private void stopPlugin() {
        try {
            this.pluginManager.setPluginEnabled((Plugin)this, false);
            this.pluginManager.stopPlugin((Plugin)this);
        }
        catch (PluginInstantiationException ex) {
            log.error("error stopping plugin", (Throwable)ex);
        }
    }

    private String buildTitle() {
        String notificationTitle = "RuneLite";
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return notificationTitle;
        }
        String name = player.getName();
        if (Strings.isNullOrEmpty((String)name)) {
            return notificationTitle;
        }
        return notificationTitle + " - " + name;
    }

    private void setNotificationTray(boolean enable) {
        if (OSType.getOSType() == OSType.MacOS) {
            this.configManager.setConfiguration("runelite", "notificationTray", (Object)enable);
        }
    }
}

