/*
 * Decompiled with CFR 0.152.
 */
package ejedev.raidshamer;

import com.google.inject.Provides;
import ejedev.raidshamer.DiscordWebhook;
import ejedev.raidshamer.RaidShamerConfig;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.util.ImageCapture;
import net.runelite.client.util.ImageUploadStyle;

@PluginDescriptor(name="Raid Shamer", description="Takes a screenshot of deaths during bosses and raids. Supports discord webhook integration.", tags={"death", "raid", "raids", "shame", "tob", "theater", "cox", "chambers", "discord", "webhook"}, loadWhenOutdated=true, enabledByDefault=false)
public class RaidShamerPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private ImageCapture imageCapture;
    @Inject
    private DrawManager drawManager;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private RaidShamerConfig config;
    private boolean inTob;

    @Provides
    RaidShamerConfig provideConfig(ConfigManager configManager) {
        return (RaidShamerConfig)configManager.getConfig(RaidShamerConfig.class);
    }

    @Subscribe
    public void onActorDeath(ActorDeath actorDeath) {
        Actor actor = actorDeath.getActor();
        if (actor instanceof Player) {
            Player player = (Player)actor;
            if (this.shouldTakeScreenshot(player)) {
                this.takeScreenshot("Death of " + player.getName(), "Wall of Shame");
            } else {
                System.out.println("[DEBUG] Not in shameable zone sorry.");
            }
        }
    }

    private boolean shouldTakeScreenshot(Player player) {
        boolean isPlayerValidTarget = this.config.captureOwnDeaths() || !this.config.captureOwnDeaths() && player != this.client.getLocalPlayer();
        boolean inRaid = this.client.getVarbitValue(5432) > 0;
        Widget toaWidget = this.client.getWidget(WidgetInfo.TOA_RAID_LAYER);
        boolean inToa = toaWidget != null;
        boolean isInValidRaid = this.inTob || this.config.activeInCoX() && inRaid || this.config.activeInToA() && inToa;
        return isInValidRaid && isPlayerValidTarget;
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        this.inTob = this.client.getVarbitValue(6440) > 1;
    }

    private void takeScreenshot(String fileName, String subDir) {
        Consumer<Image> imageCallback = img -> this.executor.submit(() -> {
            try {
                this.takeScreenshot(fileName, subDir, (Image)img);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        this.drawManager.requestNextFrameListener(imageCallback);
    }

    private void takeScreenshot(String fileName, String subDir, Image image) throws IOException {
        BufferedImage screenshot = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics graphics = screenshot.getGraphics();
        int gameOffsetX = 0;
        int gameOffsetY = 0;
        graphics.drawImage(image, gameOffsetX, gameOffsetY, null);
        this.imageCapture.takeScreenshot(screenshot, fileName, subDir, false, ImageUploadStyle.NEITHER);
        ByteArrayOutputStream screenshotOutput = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)screenshot, "png", screenshotOutput);
        if (this.config.webhookEnabled() && !this.config.webhookLink().equals("")) {
            DiscordWebhook FileSender = new DiscordWebhook();
            FileSender.SendWebhook(screenshotOutput, fileName, this.config.webhookLink());
        }
    }

    public boolean isInTob() {
        return this.inTob;
    }
}

