/*
 * Decompiled with CFR 0.152.
 */
package dev.kocken.touchbar;

import dev.kocken.TouchBarPluginConfig;
import dev.kocken.nativebridge.JavaTouchBar;
import dev.kocken.nativebridge.common.Image;
import dev.kocken.nativebridge.item.TouchBarItem;
import dev.kocken.nativebridge.item.view.TouchBarButton;
import dev.kocken.touchbar.TouchBarConfiguration;
import java.awt.AWTException;
import java.awt.Frame;
import java.awt.Robot;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TouchBarManager {
    private static final int TAB_BUTTONS_COUNT = 7;
    private final TouchBarConfiguration touchBarConfig;
    private final JavaTouchBar touchBar;
    private final Robot robot;
    private final List<TouchBarButton> tabButtons = new ArrayList<TouchBarButton>();
    private final List<TouchBarItem> tabItems = new ArrayList<TouchBarItem>();
    private TouchBarPluginConfig config;
    private boolean isTopRowActive = true;

    public TouchBarManager(TouchBarPluginConfig config) throws AWTException {
        this.touchBarConfig = new TouchBarConfiguration();
        this.touchBar = new JavaTouchBar();
        this.robot = new Robot();
        this.config = config;
        this.InitializeTabButtons();
        this.SetTabButtons();
    }

    public void ShowTouchBar() {
        this.touchBar.setItems(this.tabItems);
        for (Frame frame : Frame.getFrames()) {
            this.touchBar.show(frame);
        }
    }

    public void HideTouchBar() {
        for (Frame frame : Frame.getFrames()) {
            this.touchBar.hide(frame);
        }
    }

    private void SwitchRows() {
        this.isTopRowActive = !this.isTopRowActive;
        this.SetTabButtons();
    }

    private void InitializeTabButtons() {
        for (int i = 0; i < 7; ++i) {
            this.tabButtons.add(new TouchBarButton());
            this.tabItems.add(new TouchBarItem(String.valueOf(i), this.tabButtons.get(i)));
        }
        this.tabItems.add(new TouchBarItem("switch", this.CreateSwitchRowButton()));
    }

    private void SetTabButtons() {
        Map<String, Integer> configuration = this.isTopRowActive ? this.touchBarConfig.topRowButtonsConfiguration(this.config) : this.touchBarConfig.bottomRowButtonsConfiguration(this.config);
        int index = 0;
        for (Map.Entry<String, Integer> entry : configuration.entrySet()) {
            String imageName = entry.getKey();
            Integer keyCode = entry.getValue();
            this.tabButtons.get(index).setImage(this.loadButtonImage(imageName));
            this.tabButtons.get(index).setAction(view -> this.robot.keyPress(keyCode));
            ++index;
        }
        this.ShowTouchBar();
    }

    private Image loadButtonImage(String imageName) {
        Image image = null;
        try {
            InputStream imageStream = this.getClass().getClassLoader().getResourceAsStream(String.format("images/%s.png", imageName));
            image = new Image(imageStream);
        }
        catch (IOException error) {
            error.printStackTrace();
        }
        return image;
    }

    private TouchBarButton CreateSwitchRowButton() {
        TouchBarButton switchRowButton = new TouchBarButton();
        switchRowButton.setTitle("\u2195\ufe0e");
        switchRowButton.setAction(view -> this.SwitchRows());
        return switchRowButton;
    }

    public void UpdatePluginConfig(TouchBarPluginConfig config) {
        this.config = config;
        this.SetTabButtons();
    }
}

