/*
 * Decompiled with CFR 0.152.
 */
package dev.kocken.nativebridge.swing;

import dev.kocken.nativebridge.item.view.TouchBarButton;
import dev.kocken.nativebridge.item.view.TouchBarView;
import dev.kocken.nativebridge.item.view.action.TouchBarViewAction;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class SwingTouchBarActionDelegate
implements TouchBarViewAction {
    private static final String PROPERTY_NAME_ENABLED = "enabled";
    private final Action action;
    private final PropertyChangeListener propertyChangeListener;

    public SwingTouchBarActionDelegate(Action action, TouchBarButton touchBarButton) {
        Objects.requireNonNull(action, "action");
        Objects.requireNonNull(touchBarButton, "touchBarButton");
        this.action = action;
        this.propertyChangeListener = event -> {
            if (PROPERTY_NAME_ENABLED.equals(event.getPropertyName())) {
                touchBarButton.fireActionStateChanged();
            }
        };
        this.action.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void destroy() {
        this.action.removePropertyChangeListener(this.propertyChangeListener);
    }

    protected boolean isOnEDT() {
        return SwingUtilities.isEventDispatchThread();
    }

    protected ActionEvent getActionEvent() {
        return new ActionEvent(this, 0, null);
    }

    @Override
    public void onCall(TouchBarView view) {
        if (this.isOnEDT()) {
            this.callAction();
        } else {
            SwingUtilities.invokeLater(this::callAction);
        }
    }

    private void callAction() {
        this.action.actionPerformed(this.getActionEvent());
    }

    @Override
    public boolean isEnabled() {
        return this.action.isEnabled();
    }
}

