/*
 * Decompiled with CFR 0.152.
 */
package dev.kocken;

import com.google.inject.Provides;
import dev.kocken.TouchBarPluginConfig;
import dev.kocken.touchbar.TouchBarManager;
import javax.inject.Inject;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Touch Bar")
public class TouchBarPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TouchBarPlugin.class);
    @Inject
    private TouchBarPluginConfig config;
    private TouchBarManager touchBarManager;

    protected void startUp() throws Exception {
        this.touchBarManager = new TouchBarManager(this.config);
        log.info("Touch Bar Plugin started!");
    }

    protected void shutDown() {
        this.touchBarManager.HideTouchBar();
        log.info("Touch Bar Plugin stopped!");
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState state = gameStateChanged.getGameState();
        if (state == GameState.LOGGED_IN) {
            this.touchBarManager.ShowTouchBar();
        }
        if (state == GameState.LOGIN_SCREEN) {
            this.touchBarManager.HideTouchBar();
        }
    }

    @Provides
    TouchBarPluginConfig provideConfig(ConfigManager configManager) {
        return (TouchBarPluginConfig)configManager.getConfig(TouchBarPluginConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged newConfig) {
        this.touchBarManager.UpdatePluginConfig(this.config);
    }
}

