/*
 * Decompiled with CFR 0.152.
 */
package de0.miasmatiles;

import de0.miasmatiles.MiasmaTilesConfig;
import de0.miasmatiles.MiasmaTilesData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

public class MiasmaTilesOverlay
extends Overlay {
    private Client client;
    private MiasmaTilesConfig config;

    @Inject
    MiasmaTilesOverlay(Client client, MiasmaTilesConfig config) {
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D g) {
        WorldPoint wp = this.client.getLocalPlayer().getWorldLocation();
        int region = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)LocalPoint.fromWorld((Client)this.client, (WorldPoint)wp)).getRegionID();
        if (region != 12889) {
            return null;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.config.thinOutline() ? RenderingHints.VALUE_ANTIALIAS_OFF : RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(new BasicStroke(this.config.thinOutline() ? 1.0f : 2.0f));
        for (int[] tile_data : MiasmaTilesData.TILES) {
            int x = tile_data[0] + 16;
            int y = tile_data[1] + 32;
            int color = tile_data[2];
            if (color == 0 && this.config.showBurnTiles()) {
                this.draw_tile(g, x, y, this.config.burnTileColor());
                continue;
            }
            if (color != 1 || !this.config.showOlmTiles()) continue;
            this.draw_tile(g, x, y, this.config.olmTileColor());
        }
        return null;
    }

    private void draw_tile(Graphics2D g, int x, int y, Color c) {
        g.setColor(c);
        this.line(g, x, y, x, y + 1);
        this.line(g, x + 1, y, x + 1, y + 1);
        this.line(g, x, y, x + 1, y);
        this.line(g, x, y + 1, x + 1, y + 1);
    }

    private void line(Graphics g, int x0, int y0, int x1, int y1) {
        if (x0 < 0 || y0 < 0 || x1 < 0 || y1 < 0) {
            return;
        }
        if (x0 >= 104 || y0 >= 104 || x1 >= 104 || y1 >= 104) {
            return;
        }
        int p = this.client.getPlane();
        int[][][] h = this.client.getTileHeights();
        Point p0 = Perspective.localToCanvas((Client)this.client, (int)(x0 << 7), (int)(y0 << 7), (int)h[p][x0][y0]);
        Point p1 = Perspective.localToCanvas((Client)this.client, (int)(x1 << 7), (int)(y1 << 7), (int)h[p][x1][y1]);
        if (p0 != null && p1 != null) {
            g.drawLine(p0.getX(), p0.getY(), p1.getX(), p1.getY());
        }
    }
}

