/*
 * Decompiled with CFR 0.152.
 */
package treecount;

import com.google.inject.Provides;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.coords.Angle;
import net.runelite.api.coords.Direction;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.PlayerDespawned;
import net.runelite.api.events.PlayerSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import treecount.PlayerOrientationChanged;
import treecount.Tree;
import treecount.TreeCountConfig;
import treecount.TreeCountOverlay;

@PluginDescriptor(name="Tree Count", description="Show the number of players chopping a tree", tags={"woodcutting", "wc", "tree", "count", "forestry", "overlay"})
public class TreeCountPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TreeCountPlugin.class);
    @Inject
    private Client client;
    @Inject
    private TreeCountConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TreeCountOverlay overlay;
    private final Map<GameObject, Integer> treeMap = new HashMap<GameObject, Integer>();
    private final Map<Player, GameObject> playerMap = new HashMap<Player, GameObject>();
    private final Map<GameObject, List<WorldPoint>> treeTileMap = new HashMap<GameObject, List<WorldPoint>>();
    private final Map<WorldPoint, GameObject> tileTreeMap = new HashMap<WorldPoint, GameObject>();
    private final Map<Player, Integer> playerOrientationMap = new ConcurrentHashMap<Player, Integer>();
    private int previousPlane;
    private boolean firstRun;

    @Provides
    TreeCountConfig provideConfig(ConfigManager configManager) {
        return (TreeCountConfig)configManager.getConfig(TreeCountConfig.class);
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.treeMap.clear();
        this.treeTileMap.clear();
        this.tileTreeMap.clear();
        this.playerMap.clear();
        this.playerOrientationMap.clear();
        this.previousPlane = -1;
        this.firstRun = true;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged changedConfig) {
        if (changedConfig.getKey().equals("includeSelf")) {
            if (Boolean.valueOf(changedConfig.getNewValue()).booleanValue()) {
                if (this.isWoodcutting((Actor)this.client.getLocalPlayer())) {
                    this.addToTreeFocusedMaps(this.client.getLocalPlayer());
                }
            } else {
                this.removeFromTreeMaps(this.client.getLocalPlayer());
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.isRegionInWoodcuttingGuild(this.client.getLocalPlayer().getWorldLocation().getRegionID()) && !this.config.enableWCGuild()) {
            return;
        }
        int currentPlane = this.client.getPlane();
        if (this.previousPlane != currentPlane) {
            this.treeMap.replaceAll((k, v) -> 0);
            this.previousPlane = currentPlane;
        }
        if (this.firstRun) {
            this.client.getPlayers().forEach(player -> {
                if (!player.equals(this.client.getLocalPlayer()) || this.config.includeSelf()) {
                    this.playerMap.putIfAbsent((Player)player, (GameObject)null);
                    this.playerOrientationMap.put((Player)player, -1);
                }
            });
            for (Player player2 : this.playerMap.keySet()) {
                if (!this.isWoodcutting((Actor)player2) || this.treeMap.isEmpty()) continue;
                this.addToTreeFocusedMaps(player2);
            }
        }
        if (!this.playerOrientationMap.isEmpty()) {
            for (Map.Entry<Player, Integer> playerOrientationEntry : this.playerOrientationMap.entrySet()) {
                Player player3 = playerOrientationEntry.getKey();
                int previousOrientation = playerOrientationEntry.getValue();
                int currentOrientation = player3.getOrientation();
                if (currentOrientation == previousOrientation) continue;
                PlayerOrientationChanged playerOrientationChanged = new PlayerOrientationChanged(player3, previousOrientation, currentOrientation);
                this.onPlayerOrientationChanged(playerOrientationChanged);
            }
        }
        if (this.firstRun) {
            this.firstRun = false;
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject gameObject = event.getGameObject();
        if (this.isRegionInWoodcuttingGuild(gameObject.getWorldLocation().getRegionID()) && !this.config.enableWCGuild()) {
            return;
        }
        Tree tree = Tree.findTree(gameObject.getId());
        if (tree != null) {
            log.debug("Tree {} spawned at {}", (Object)tree, (Object)gameObject.getLocalLocation());
            this.treeMap.put(gameObject, 0);
            List<WorldPoint> points = this.getPoints(gameObject);
            this.treeTileMap.put(gameObject, points);
            points.forEach(point -> this.tileTreeMap.put((WorldPoint)point, gameObject));
        }
    }

    private List<WorldPoint> getPoints(GameObject gameObject) {
        WorldPoint maxPoint;
        WorldPoint minPoint = this.getSWWorldPoint(gameObject);
        if (minPoint.equals((Object)(maxPoint = this.getNEWorldPoint(gameObject)))) {
            return Collections.singletonList(minPoint);
        }
        int plane = minPoint.getPlane();
        ArrayList<WorldPoint> list = new ArrayList<WorldPoint>();
        for (int x = minPoint.getX(); x <= maxPoint.getX(); ++x) {
            for (int y = minPoint.getY(); y <= maxPoint.getY(); ++y) {
                list.add(new WorldPoint(x, y, plane));
            }
        }
        return list;
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        GameObject gameObject = event.getGameObject();
        if (this.isRegionInWoodcuttingGuild(gameObject.getWorldLocation().getRegionID()) && !this.config.enableWCGuild()) {
            return;
        }
        Tree tree = Tree.findTree(gameObject.getId());
        if (tree != null && !tree.equals((Object)Tree.REGULAR_TREE)) {
            this.treeMap.remove(gameObject);
            List<WorldPoint> points = this.treeTileMap.remove(gameObject);
            if (points != null) {
                points.forEach(this.tileTreeMap::remove);
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            this.treeMap.clear();
            this.treeTileMap.clear();
            this.tileTreeMap.clear();
            this.playerMap.clear();
            this.playerOrientationMap.clear();
            this.firstRun = true;
        }
    }

    @Subscribe
    public void onPlayerSpawned(PlayerSpawned event) {
        if (this.firstRun) {
            return;
        }
        Player player = event.getPlayer();
        log.debug("Player {} spawned at {}", (Object)player.getName(), (Object)player.getWorldLocation());
        if (player.equals(this.client.getLocalPlayer()) && !this.config.includeSelf()) {
            return;
        }
        if (this.isRegionInWoodcuttingGuild(player.getWorldLocation().getRegionID()) && !this.config.enableWCGuild()) {
            return;
        }
        if (!this.playerMap.containsKey(player)) {
            this.playerMap.put(player, null);
            this.playerOrientationMap.put(player, player.getOrientation());
            if (this.isWoodcutting((Actor)player)) {
                this.addToTreeFocusedMaps(player);
            }
        }
    }

    @Subscribe
    public void onPlayerDespawned(PlayerDespawned event) {
        Player player = event.getPlayer();
        log.debug("Player {} despawned at {}", (Object)player.getName(), (Object)player.getWorldLocation());
        if (player.equals(this.client.getLocalPlayer()) && !this.config.includeSelf()) {
            return;
        }
        if (this.isRegionInWoodcuttingGuild(player.getWorldLocation().getRegionID()) && !this.config.enableWCGuild()) {
            return;
        }
        this.playerOrientationMap.remove(player);
        this.removeFromTreeMaps(player);
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (this.firstRun) {
            return;
        }
        if (event.getActor() instanceof Player) {
            Player player = (Player)event.getActor();
            if (Objects.equals(player, this.client.getLocalPlayer()) && !this.config.includeSelf()) {
                return;
            }
            if (player.getCombatLevel() != 0 && this.isRegionInWoodcuttingGuild(player.getWorldLocation().getRegionID()) && !this.config.enableWCGuild()) {
                return;
            }
            if (this.isWoodcutting((Actor)player) && !this.treeMap.isEmpty()) {
                this.addToTreeFocusedMaps(player);
            } else if (player.getAnimation() == -1) {
                this.removeFromTreeMaps(player);
            }
        }
    }

    @Subscribe
    public void onPlayerOrientationChanged(PlayerOrientationChanged event) {
        if (this.firstRun) {
            return;
        }
        Player player = event.getPlayer();
        Direction previousDirection = new Angle(event.getPreviousOrientation()).getNearestDirection();
        Direction currentDirection = new Angle(event.getCurrentOrientation()).getNearestDirection();
        log.debug("Player {} orientation changed from {} ({}) to {} ({})", new Object[]{player.getName(), event.getPreviousOrientation(), previousDirection, event.getCurrentOrientation(), currentDirection});
        if (player.equals(this.client.getLocalPlayer()) && !this.config.includeSelf()) {
            return;
        }
        if (this.isRegionInWoodcuttingGuild(player.getWorldLocation().getRegionID()) && !this.config.enableWCGuild()) {
            return;
        }
        this.playerOrientationMap.put(player, event.getCurrentOrientation());
        this.removeFromTreeMaps(player);
        if (this.isWoodcutting((Actor)player)) {
            this.addToTreeFocusedMaps(player);
        }
    }

    boolean isWoodcutting(Actor actor) {
        return this.isWoodcuttingWithRegularAxe(actor) || this.isWoodcuttingWithFellingAxe(actor);
    }

    private boolean isWoodcuttingWithRegularAxe(Actor actor) {
        switch (actor.getAnimation()) {
            case 24: 
            case 867: 
            case 869: 
            case 871: 
            case 873: 
            case 875: 
            case 877: 
            case 879: 
            case 2117: 
            case 2846: 
            case 7264: 
            case 8303: 
            case 8324: 
            case 8778: {
                return true;
            }
        }
        return false;
    }

    private boolean isWoodcuttingWithFellingAxe(Actor actor) {
        switch (actor.getAnimation()) {
            case 10064: 
            case 10065: 
            case 10066: 
            case 10067: 
            case 10068: 
            case 10069: 
            case 10070: 
            case 10071: 
            case 10072: 
            case 10074: {
                return true;
            }
        }
        return false;
    }

    void addToTreeFocusedMaps(Player player) {
        GameObject closestTree = this.findClosestFacingTree((Actor)player);
        if (player != this.client.getLocalPlayer() || this.config.includeSelf()) {
            Direction direction = new Angle(player.getOrientation()).getNearestDirection();
            log.debug("Actor: {}, Direction: {}, Closest Facing Tree: {}, Count: {}", new Object[]{player.getName(), direction, closestTree != null ? closestTree.getWorldLocation() : "NULL", closestTree != null ? this.treeMap.get(closestTree) : -1});
        }
        if (closestTree == null) {
            List<GameObject> adjacentTrees;
            if (this.isWoodcutting((Actor)player) && (adjacentTrees = this.getAdjacentTrees((Actor)player, false)).size() == 1) {
                this.playerMap.put(player, adjacentTrees.get(0));
                this.treeMap.merge(adjacentTrees.get(0), 1, Integer::sum);
            }
            return;
        }
        this.playerMap.put(player, closestTree);
        this.treeMap.merge(closestTree, 1, Integer::sum);
    }

    void removeFromTreeMaps(Player player) {
        GameObject tree = this.playerMap.get(player);
        this.playerMap.remove(player);
        this.treeMap.computeIfPresent(tree, (unused, value) -> {
            log.debug("Removing player {} from tree {}. {} -> {}", new Object[]{player.getName(), tree.getWorldLocation(), value, Math.max(0, value - 1)});
            return Math.max(0, value - 1);
        });
    }

    GameObject findClosestFacingTree(Actor actor) {
        WorldPoint actorLocation = actor.getWorldLocation();
        Direction direction = new Angle(actor.getOrientation()).getNearestDirection();
        WorldPoint facingPoint = this.neighborPoint(actorLocation, direction);
        return this.tileTreeMap.get(facingPoint);
    }

    List<GameObject> getAdjacentTrees(Actor actor, boolean ignoreNonForestryTrees) {
        WorldPoint actorLocation = actor.getWorldLocation();
        ArrayList<GameObject> adjacentTrees = new ArrayList<GameObject>();
        for (Direction direction : Direction.values()) {
            WorldPoint neighborPoint = this.neighborPoint(actorLocation, direction);
            GameObject tree = this.tileTreeMap.get(neighborPoint);
            if (tree == null || ignoreNonForestryTrees && (!ignoreNonForestryTrees || Tree.findForestryTree(tree.getId()) == null)) continue;
            adjacentTrees.add(tree);
        }
        return adjacentTrees;
    }

    WorldPoint neighborPoint(WorldPoint point, Direction direction) {
        switch (direction) {
            case NORTH: {
                return point.dy(1);
            }
            case SOUTH: {
                return point.dy(-1);
            }
            case EAST: {
                return point.dx(1);
            }
            case WEST: {
                return point.dx(-1);
            }
        }
        throw new IllegalStateException();
    }

    private WorldPoint getSWWorldPoint(GameObject gameObject) {
        return this.getWorldPoint(gameObject, GameObject::getSceneMinLocation);
    }

    private WorldPoint getNEWorldPoint(GameObject gameObject) {
        return this.getWorldPoint(gameObject, GameObject::getSceneMaxLocation);
    }

    private WorldPoint getWorldPoint(GameObject gameObject, Function<GameObject, Point> pointFunction) {
        Point point = pointFunction.apply(gameObject);
        return WorldPoint.fromScene((Client)this.client, (int)point.getX(), (int)point.getY(), (int)gameObject.getPlane());
    }

    boolean isRegionInWoodcuttingGuild(int regionID) {
        return regionID == 6198 || regionID == 6454;
    }

    public Map<GameObject, Integer> getTreeMap() {
        return this.treeMap;
    }

    public Map<GameObject, List<WorldPoint>> getTreeTileMap() {
        return this.treeTileMap;
    }
}

