/*
 * Decompiled with CFR 0.152.
 */
package treecount;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.concurrent.ThreadLocalRandom;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.TileObject;
import net.runelite.api.coords.Angle;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.geometry.SimplePolygon;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import treecount.Tree;
import treecount.TreeCountConfig;
import treecount.TreeCountPlugin;

public class TreeCountOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(TreeCountOverlay.class);
    public static final Color BLANK_COLOR = new Color(0, true);
    private final TreeCountPlugin plugin;
    private final TreeCountConfig config;
    private final Client client;
    private static final Random random = ThreadLocalRandom.current();
    private static final Map<GameObject, Color> colorMap = new WeakHashMap<GameObject, Color>();

    @Inject
    private TreeCountOverlay(TreeCountPlugin plugin, TreeCountConfig config, Client client) {
        this.plugin = plugin;
        this.config = config;
        this.client = client;
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPosition(OverlayPosition.DYNAMIC);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.isRegionInWoodcuttingGuild(this.client.getLocalPlayer().getWorldLocation().getRegionID()) && !this.config.enableWCGuild()) {
            return null;
        }
        this.renderDebugOverlay(graphics);
        this.plugin.getTreeMap().forEach((gameObject, choppers) -> {
            if (choppers == null || choppers <= 0 || Tree.findForestryTree(gameObject.getId()) == null) {
                return;
            }
            Color colorForChoppers = TreeCountOverlay.getColorForChoppers(choppers);
            if (this.config.renderTreeHull()) {
                if (choppers < 10) {
                    TreeCountOverlay.drawOutline(graphics, gameObject, colorForChoppers, 80, 1.0f);
                } else {
                    TreeCountOverlay.drawOutline(graphics, gameObject, colorForChoppers, 176, 2.0f);
                }
            }
            TreeCountOverlay.centroidOfObjectHull(gameObject).ifPresent(point -> TreeCountOverlay.drawTextCentered(graphics, point, String.valueOf(choppers), colorForChoppers));
        });
        return null;
    }

    private static void drawTextCentered(Graphics2D graphics, Point point, String text, Color color) {
        FontMetrics metrics = graphics.getFontMetrics(graphics.getFont());
        Rectangle2D bounds = metrics.getStringBounds(text, graphics);
        int x = point.getX() - (int)Math.round(bounds.getWidth()) / 2;
        int y = point.getY() + (int)Math.round(bounds.getHeight()) / 2;
        OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(x, y), (String)text, (Color)color);
    }

    private static Optional<Point> centroidOfObjectHull(GameObject gameObject) {
        Shape convexHull = gameObject.getConvexHull();
        if (!(convexHull instanceof SimplePolygon)) {
            return Optional.empty();
        }
        return TreeCountOverlay.centroidOfPolygon((SimplePolygon)convexHull);
    }

    private static Optional<Point> centroidOfPolygon(SimplePolygon poly) {
        long xSum = 0L;
        long ySum = 0L;
        long areaSum = 0L;
        for (int i = 0; i < poly.size(); ++i) {
            long currX = poly.getX(i);
            long currY = poly.getY(i);
            int nextI = i == poly.size() - 1 ? 0 : i + 1;
            long nextX = poly.getX(nextI);
            long nextY = poly.getY(nextI);
            long areaSumComponent = currX * nextY - nextX * currY;
            areaSum += areaSumComponent;
            xSum += (currX + nextX) * areaSumComponent;
            ySum += (currY + nextY) * areaSumComponent;
        }
        long divisor = areaSum * 3L;
        long centroidX = xSum / divisor;
        long centroidY = ySum / divisor;
        return Optional.of(new Point((int)centroidX, (int)centroidY));
    }

    private static void drawOutline(Graphics2D graphics, GameObject gameObject, Color colorForChoppers, int alpha, float strokeWidth) {
        Color outlineColor = ColorUtil.colorWithAlpha((Color)colorForChoppers, (int)alpha);
        BasicStroke stroke = new BasicStroke(strokeWidth);
        OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)gameObject.getConvexHull(), (Color)outlineColor, (Color)BLANK_COLOR, (Stroke)stroke);
    }

    private static Color getColorForChoppers(int choppers) {
        float percent = Math.min(1.0f, (float)choppers / 10.0f);
        float hue1 = TreeCountOverlay.rgbToHsbArray(Color.RED)[0];
        float hue2 = TreeCountOverlay.rgbToHsbArray(Color.GREEN)[0];
        float lerpedHue = hue1 + (hue2 - hue1) * percent;
        return Color.getHSBColor(lerpedHue, 1.0f, 1.0f);
    }

    private static float[] rgbToHsbArray(Color color) {
        return Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
    }

    private void renderDebugOverlay(Graphics2D graphics) {
        if (this.config.renderFacingTree()) {
            this.renderFacingTree(graphics);
        }
        if (this.config.renderTreeTiles()) {
            this.renderTreeTiles(graphics);
        }
        if (this.config.renderPlayerOrientation()) {
            this.renderPlayerOrientation(graphics);
        }
        if (this.config.renderExpectedChoppers()) {
            this.renderPlayersAdjacentToTrees(graphics);
        }
    }

    private void renderFacingTree(Graphics2D graphics) {
        GameObject tree;
        if (this.client.getLocalPlayer() != null && (tree = this.plugin.findClosestFacingTree((Actor)this.client.getLocalPlayer())) != null) {
            OverlayUtil.renderTileOverlay((Graphics2D)graphics, (TileObject)tree, (String)"", (Color)Color.GREEN);
        }
    }

    private void renderTreeTiles(Graphics2D graphics) {
        this.plugin.getTreeTileMap().forEach((tree, tiles) -> {
            Color color = colorMap.computeIfAbsent((GameObject)tree, unused -> Color.getHSBColor(random.nextFloat(), 1.0f, 1.0f));
            tiles.forEach(worldPoint -> {
                LocalPoint localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldPoint);
                if (localPoint == null) {
                    return;
                }
                Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)localPoint);
                if (poly == null) {
                    return;
                }
                OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color);
            });
        });
    }

    private void renderPlayerOrientation(Graphics2D graphics) {
        this.client.getPlayers().forEach(player -> {
            Angle playerAngle = new Angle(player.getOrientation());
            String text = player.getOrientation() + " | " + playerAngle.getNearestDirection();
            Point textPoint = player.getCanvasTextLocation(graphics, text, player.getLogicalHeight() + 40);
            if (textPoint != null) {
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textPoint, (String)text, (Color)Color.GREEN);
            }
        });
    }

    private void renderPlayersAdjacentToTrees(Graphics2D graphics) {
        HashMap<GameObject, Integer> expectedChoppers = new HashMap<GameObject, Integer>();
        for (Player player : this.client.getPlayers()) {
            if (player.equals(this.client.getLocalPlayer()) && !this.config.includeSelf()) continue;
            this.plugin.getAdjacentTrees((Actor)player, false).forEach(tree -> {
                if (this.plugin.isWoodcutting((Actor)player)) {
                    expectedChoppers.put((GameObject)tree, expectedChoppers.getOrDefault(tree, 0) + 1);
                }
            });
        }
        expectedChoppers.forEach((tree, finalExpectedCount) -> {
            Color colorForChoppers = TreeCountOverlay.getColorForChoppers(finalExpectedCount);
            TreeCountOverlay.centroidOfObjectHull(tree).ifPresent(point -> TreeCountOverlay.drawTextCentered(graphics, new Point(point.getX(), point.getY() + 15), "Expected: " + finalExpectedCount, colorForChoppers));
        });
    }
}

