/*
 * Decompiled with CFR 0.152.
 */
package treecount;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum Tree {
    OAK_TREE(true, 9734, 10820, 37969, 42395, 42831),
    WILLOW_TREE(true, 10819, 10829, 10831, 10833),
    TEAK_TREE(true, 9036, 15062, 36686, 40758),
    MAPLE_TREE(true, 4674, 10832, 36681, 40754),
    ARCTIC_PINE_TREE(true, 3037),
    HOLLOW_TREE(true, 10821, 10830),
    MAHOGANY_TREE(true, 9034, 40760, 36688),
    YEW_TREE(true, 10822, 10823, 36683, 40756, 42391),
    MAGIC_TREE(true, 10834, 36685),
    REDWOOD_TREE(true, 29668, 29670, 34284, 34286, 34288, 34290),
    REGULAR_TREE(false, 1276, 1277, 1278, 1279, 1280, 1330, 1331, 1332, 2409, 3879, 3881, 3882, 3883, 9730, 9731, 9732, 9733, 14308, 14309, 16264, 16265, 36672, 36674, 36677, 36679, 37965, 37967, 37971, 37973, 40750, 40752, 42393, 42832),
    DEAD_TREE(false, 1282, 1283, 1284, 1285, 1286, 1289, 1290, 1291, 1365, 1383, 1384, 5902, 5903, 5904, 42907),
    DRAMEN_TREE(false, 1292),
    EVERGREEN_TREE(false, 1318, 1319, 2091, 2092, 27060, 40932, 40933),
    ACHEY_TREE(false, 2023),
    JUNGLE_TREE(false, 2887, 2889, 2890, 4818, 4820),
    DYING_TREE(false, 3648),
    DREAM_TREE(false, 16604),
    WINDSWEPT_TREE(false, 18137),
    MATURE_JUNIPER_TREE(false, 27499),
    BURNT_TREE(false, 30852, 30854),
    BLISTERWOOD_TREE(false, 37989),
    RISING_ROOTS(false, 47482, 47483);

    private final boolean providesForestryBoost;
    private final int[] treeIds;
    private static final Map<Integer, Tree> ALL_TREES;
    private static final Map<Integer, Tree> FORESTRY_TREES;

    private Tree(boolean providesForestryBoost, int ... treeIds) {
        this.providesForestryBoost = providesForestryBoost;
        this.treeIds = treeIds;
    }

    static Tree findTree(int objectId) {
        return ALL_TREES.get(objectId);
    }

    static Tree findForestryTree(int objectId) {
        return FORESTRY_TREES.get(objectId);
    }

    public boolean isProvidesForestryBoost() {
        return this.providesForestryBoost;
    }

    public int[] getTreeIds() {
        return this.treeIds;
    }

    static {
        ImmutableMap.Builder allTreesBuilder = new ImmutableMap.Builder();
        ImmutableMap.Builder forestryTreesBuilder = new ImmutableMap.Builder();
        for (Tree tree : Tree.values()) {
            for (int treeId : tree.treeIds) {
                allTreesBuilder.put((Object)treeId, (Object)tree);
                if (!tree.providesForestryBoost) continue;
                forestryTreesBuilder.put((Object)treeId, (Object)tree);
            }
        }
        ALL_TREES = allTreesBuilder.build();
        FORESTRY_TREES = forestryTreesBuilder.build();
    }
}

