/*
 * Decompiled with CFR 0.152.
 */
package com.CapeCounterPlugin;

import com.CapeCounterPlugin.CapeCounterConfig;
import com.CapeCounterPlugin.CapeCounterOverlay;
import com.CapeCounterPlugin.Capes;
import com.google.inject.Provides;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.events.PlayerChanged;
import net.runelite.api.events.PlayerDespawned;
import net.runelite.api.events.PlayerSpawned;
import net.runelite.api.kit.KitType;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Cape Counter")
public class CapeCounterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CapeCounterPlugin.class);
    private final Map<Player, Integer> playerCapes = new HashMap<Player, Integer>();
    @Inject
    private Client client;
    @Inject
    private CapeCounterConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private CapeCounterOverlay capeCounterOverlay;

    protected void startUp() {
        this.overlayManager.add((Overlay)this.capeCounterOverlay);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.capeCounterOverlay);
    }

    @Provides
    CapeCounterConfig provideConfig(ConfigManager configManager) {
        return (CapeCounterConfig)configManager.getConfig(CapeCounterConfig.class);
    }

    @Subscribe
    public void onPlayerSpawned(PlayerSpawned event) {
        Player player = event.getPlayer();
        if (this.doesPlayerHaveCape(player)) {
            this.playerCapes.put(player, player.getPlayerComposition().getEquipmentId(KitType.CAPE));
        }
    }

    @Subscribe
    public void onPlayerDespawned(PlayerDespawned playerDespawned) {
        Player player = playerDespawned.getPlayer();
        this.playerCapes.remove(player);
    }

    @Subscribe
    public void onPlayerChanged(PlayerChanged playerChanged) {
        this.playerCapes.remove(playerChanged.getPlayer());
        if (this.doesPlayerHaveCape(playerChanged.getPlayer())) {
            this.playerCapes.put(playerChanged.getPlayer(), playerChanged.getPlayer().getPlayerComposition().getEquipmentId(KitType.CAPE));
        }
    }

    private boolean doesPlayerHaveCape(Player player) {
        if (player.getPlayerComposition().getEquipmentId(KitType.CAPE) == -1) {
            return false;
        }
        for (Capes cape : Capes.values()) {
            if (player.getPlayerComposition().getEquipmentId(KitType.CAPE) != cape.getItemId()) continue;
            return true;
        }
        return false;
    }

    Map<Player, Integer> getPlayerCapes() {
        return this.playerCapes;
    }
}

