/*
 * Decompiled with CFR 0.152.
 */
package com.CapeCounterPlugin;

import com.CapeCounterPlugin.CapeCounterConfig;
import com.CapeCounterPlugin.CapeCounterPlugin;
import com.CapeCounterPlugin.Capes;
import com.google.inject.Inject;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import net.runelite.api.MenuAction;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.ImageComponent;

public class CapeCounterOverlay
extends OverlayPanel {
    private final CapeCounterPlugin plugin;
    private final CapeCounterConfig config;
    private final ItemManager manager;

    @Inject
    private CapeCounterOverlay(CapeCounterPlugin plugin, CapeCounterConfig config, ItemManager manager) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.LOW);
        this.plugin = plugin;
        this.config = config;
        this.manager = manager;
        this.panelComponent.setWrap(true);
        this.panelComponent.setOrientation(ComponentOrientation.HORIZONTAL);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Cape Counter overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        for (Capes cape : Capes.values()) {
            int count = Collections.frequency(this.plugin.getPlayerCapes().values(), cape.getItemId());
            if (count < this.config.getMinimumCapeCount()) continue;
            this.panelComponent.getChildren().add(new ImageComponent((BufferedImage)this.manager.getImage(cape.getItemId(), count, true)));
        }
        return super.render(graphics);
    }
}

