/*
 * Decompiled with CFR 0.152.
 */
package io.robrichardson.challengemodeindicator;

import com.google.inject.Provides;
import io.robrichardson.challengemodeindicator.ChallengeModeIndicatorConfig;
import io.robrichardson.challengemodeindicator.ChallengeModeIndicatorOverlay;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.Tile;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Challenge Mode Indicator")
public class ChallengeModeIndicatorPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ChallengeModeIndicatorPlugin.class);
    final List<Integer> leverIds = new ArrayList<Integer>(Arrays.asList(13672, 13673, 13674));
    @Inject
    private Client client;
    @Inject
    private ChallengeModeIndicatorConfig config;
    @Inject
    private ChallengeModeIndicatorOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    private boolean challengeModeActivated = false;
    private GameObject leverObject;
    private Tile leverTile;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.leverObject = null;
        this.leverTile = null;
    }

    @Provides
    ChallengeModeIndicatorConfig provideConfig(ConfigManager configManager) {
        return (ChallengeModeIndicatorConfig)configManager.getConfig(ChallengeModeIndicatorConfig.class);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.HOPPING || event.getGameState() == GameState.LOGIN_SCREEN) {
            this.challengeModeActivated = false;
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject gameObject = event.getGameObject();
        int id = gameObject.getId();
        if (this.leverIds.contains(id)) {
            this.leverObject = gameObject;
            this.leverTile = event.getTile();
        }
    }

    @Subscribe
    private void onGameObjectDespawned(GameObjectDespawned event) {
        GameObject gameObject = event.getGameObject();
        int id = gameObject.getId();
        if (this.leverIds.contains(id)) {
            this.leverObject = null;
            this.leverTile = null;
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.SPAM && event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String enableString = "Challenge mode is on.";
        String disableString = "Challenge mode has ended.";
        if (Objects.equals(event.getMessage(), enableString)) {
            this.challengeModeActivated = true;
        } else if (Objects.equals(event.getMessage(), disableString)) {
            this.challengeModeActivated = false;
        }
    }

    public boolean isChallengeModeActivated() {
        return this.challengeModeActivated;
    }

    public GameObject getLeverObject() {
        return this.leverObject;
    }

    public Tile getLeverTile() {
        return this.leverTile;
    }
}

