/*
 * Decompiled with CFR 0.152.
 */
package io.robrichardson.challengemodeindicator;

import com.google.inject.Inject;
import io.robrichardson.challengemodeindicator.ChallengeModeIndicatorConfig;
import io.robrichardson.challengemodeindicator.ChallengeModeIndicatorPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChallengeModeIndicatorOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(ChallengeModeIndicatorOverlay.class);
    private static final int MAX_DISTANCE = 2350;
    private final Client client;
    private final ChallengeModeIndicatorConfig config;
    private final ChallengeModeIndicatorPlugin plugin;

    @Inject
    ChallengeModeIndicatorOverlay(Client client, ChallengeModeIndicatorConfig config, ChallengeModeIndicatorPlugin plugin) {
        super((Plugin)plugin);
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        Player player = this.client.getLocalPlayer();
        if (this.plugin.isChallengeModeActivated() && player != null && this.plugin.getLeverObject() != null && this.plugin.getLeverTile() != null) {
            Point textLocation;
            LocalPoint playerLocation = player.getLocalLocation();
            LocalPoint leverLocation = this.plugin.getLeverObject().getLocalLocation();
            if (this.plugin.getLeverTile().getPlane() == this.client.getPlane() && playerLocation.distanceTo(leverLocation) <= 2350 && this.plugin.getLeverObject().getSceneMinLocation().equals((Object)this.plugin.getLeverTile().getSceneLocation()) && (textLocation = this.plugin.getLeverObject().getCanvasTextLocation(graphics, this.config.activeText(), 200)) != null) {
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)this.config.activeText(), (Color)this.config.activeColor());
            }
        }
        return null;
    }
}

