/*
 * Decompiled with CFR 0.152.
 */
package com.clockblocker;

import java.util.Iterator;
import javax.inject.Inject;
import net.runelite.api.AmbientSoundEffect;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Clock Blocker", description="Silence the grandfather clocks once and for all.", tags={"sound", "clock", "mute", "grandfather"})
public class ClockBlockerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ClockBlockerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;

    protected void startUp() throws Exception {
        log.info("Clock Blocker started!");
        this.clientThread.invoke(() -> {
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.client.setGameState(GameState.LOADING);
            }
        });
    }

    protected void shutDown() throws Exception {
        log.info("Clock Blocker stopped!");
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            Iterator ambientSounds = this.client.getAmbientSoundEffects().iterator();
            while (ambientSounds.hasNext()) {
                AmbientSoundEffect sound = (AmbientSoundEffect)ambientSounds.next();
                if (sound.getSoundEffectId() != 3120) continue;
                ambientSounds.remove();
            }
        }
    }
}

