/*
 * Decompiled with CFR 0.152.
 */
package com.coxspecialloothider;

import com.coxspecialloothider.CoxSpecialLootHiderConfig;
import com.coxspecialloothider.Tuple;
import com.google.inject.Provides;
import java.util.ArrayList;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MessageNode;
import net.runelite.api.WidgetNode;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="CoX Censor")
public class CoxSpecialLootHiderPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CoxSpecialLootHiderPlugin.class);
    @Inject
    private Client client;
    @Inject
    private CoxSpecialLootHiderConfig config;
    private ArrayList<Tuple<MessageNode, String>> revealMessages = new ArrayList();
    private ArrayList<Tuple<String, String>> listOfLoot = new ArrayList();
    private boolean itemReceived = false;
    private static final String[] listOfItems = new String[]{"Dexterous prayer scroll", "Arcane prayer scroll", "Twisted buckler", "Dragon hunter crossbow", "Dinh's bulwark", "Ancestral hat", "Ancestral robe top", "Ancestral robe bottom", "Dragon claws", "Elder maul", "Kodai insignia", "Twisted bow"};

    protected void startUp() throws Exception {
        this.client.refreshChat();
    }

    protected void shutDown() throws Exception {
        this.showLoot();
    }

    @Provides
    CoxSpecialLootHiderConfig provideConfig(ConfigManager configManager) {
        return (CoxSpecialLootHiderConfig)configManager.getConfig(CoxSpecialLootHiderConfig.class);
    }

    private void clearLists() {
        this.revealMessages.clear();
        this.listOfLoot.clear();
        this.itemReceived = false;
        this.client.refreshChat();
    }

    private void showLoot() {
        for (Tuple<MessageNode, String> message : this.revealMessages) {
            message.getFirst().setValue(message.getSecond());
            message.getFirst().setRuneLiteFormatMessage(message.getSecond());
        }
        this.clearLists();
        this.client.refreshChat();
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired scriptPreFired) {
        if (this.itemReceived && this.config.colLog()) {
            switch (scriptPreFired.getScriptId()) {
                case 3346: {
                    String notificationTopText = this.client.getVarcStrValue(387);
                    String notificationBottomText = this.client.getVarcStrValue(388);
                    if (!notificationTopText.equalsIgnoreCase("Collection log")) break;
                    for (Tuple<String, String> loot : this.listOfLoot) {
                        if (!notificationBottomText.contains(loot.getSecond())) continue;
                        for (WidgetNode node : this.client.getComponentTable()) {
                            if (node.getId() != 660) continue;
                            this.client.closeInterface(node, false);
                        }
                    }
                    break;
                }
            }
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded wid) {
        if (wid.getGroupId() == 539 || wid.getGroupId() == 271 || wid.getGroupId() == 12) {
            this.showLoot();
        }
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        block5: {
            MessageNode messageNode;
            ChatMessageType chatMessageType;
            String message;
            block7: {
                block6: {
                    if (!"chatFilterCheck".equals(event.getEventName()) || !this.itemReceived) {
                        return;
                    }
                    int[] intStack = this.client.getIntStack();
                    int intStackSize = this.client.getIntStackSize();
                    String[] stringStack = this.client.getStringStack();
                    int stringStackSize = this.client.getStringStackSize();
                    int messageType = intStack[intStackSize - 2];
                    int messageId = intStack[intStackSize - 1];
                    message = stringStack[stringStackSize - 1];
                    chatMessageType = ChatMessageType.of((int)messageType);
                    messageNode = (MessageNode)this.client.getMessages().get((long)messageId);
                    if (chatMessageType != ChatMessageType.FRIENDSCHATNOTIFICATION) break block6;
                    for (String item : listOfItems) {
                        if (!message.contains(item)) continue;
                        String censored = message.replace(item, "???");
                        this.revealMessages.add(new Tuple<MessageNode, String>(messageNode, message));
                        messageNode.setValue(censored);
                        messageNode.setRuneLiteFormatMessage(censored);
                        break block5;
                    }
                    break block5;
                }
                if (!this.itemReceived) break block5;
                if (chatMessageType != ChatMessageType.GAMEMESSAGE || !message.contains("New item added to your collection log:") && !message.contains("Valuable drop:")) break block7;
                for (Tuple<String, String> loot : this.listOfLoot) {
                    if (!message.contains(loot.getSecond())) continue;
                    this.revealMessages.add(new Tuple<MessageNode, String>(messageNode, message));
                    intStack[intStackSize - 3] = 0;
                }
                break block5;
            }
            if (chatMessageType != ChatMessageType.CLAN_MESSAGE && chatMessageType != ChatMessageType.CLAN_GIM_MESSAGE) break block5;
            for (Tuple<String, String> loot : this.listOfLoot) {
                if (!message.contains(loot.getSecond()) || !message.contains(loot.getFirst())) continue;
                if (message.contains("received a new collection log item:")) {
                    this.revealMessages.add(new Tuple<MessageNode, String>(messageNode, message));
                    intStack[intStackSize - 3] = 0;
                    break;
                }
                String value = message.substring(0, message.indexOf(":")) + ": ???";
                this.revealMessages.add(new Tuple<MessageNode, String>(messageNode, message));
                messageNode.setValue(value);
                messageNode.setRuneLiteFormatMessage(value);
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() == ChatMessageType.FRIENDSCHATNOTIFICATION) {
            for (String item : listOfItems) {
                if (!chatMessage.getMessage().contains(item)) continue;
                if (this.config.soloOnly() && !chatMessage.getMessage().contains(this.client.getLocalPlayer().getName())) {
                    return;
                }
                this.itemReceived = true;
                String name = chatMessage.getMessage().substring(12, chatMessage.getMessage().indexOf("-") - 1);
                this.listOfLoot.add(new Tuple<String, String>(name, item));
                break;
            }
        }
    }
}

