/*
 * Decompiled with CFR 0.152.
 */
package com.deathcounter;

import com.deathcounter.DeathCounter;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.events.AnimationChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.AsyncBufferedImage;

@PluginDescriptor(name="Death Counter", description="Shows death of players around you and tells you their name.", tags={})
public class DeathCounterPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    private DeathCounter counterBox;

    protected void startUp() throws Exception {
    }

    protected void shutDown() throws Exception {
        this.infoBoxManager.removeInfoBox((InfoBox)this.counterBox);
        this.counterBox = null;
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        Actor actor = event.getActor();
        if (!(actor instanceof Player)) {
            return;
        }
        if (actor.getHealthRatio() != 0) {
            return;
        }
        if (actor.getAnimation() != 836) {
            return;
        }
        if (this.counterBox != null) {
            this.counterBox.setCount(this.counterBox.getCount() + 1);
            this.sendChatMessage(actor.getName() + "just lost bank!");
        } else {
            this.updateInfobox();
        }
    }

    private void updateInfobox() {
        this.removeInfobox();
        AsyncBufferedImage image = this.itemManager.getImage(526, 1, false);
        this.counterBox = new DeathCounter(this, 526, 1, "ded", (BufferedImage)image);
        this.infoBoxManager.addInfoBox((InfoBox)this.counterBox);
    }

    private void removeInfobox() {
        this.infoBoxManager.removeInfoBox((InfoBox)this.counterBox);
        this.counterBox = null;
    }

    private void sendChatMessage(String chatMessage) {
        String message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(chatMessage).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
    }
}

