/*
 * Decompiled with CFR 0.152.
 */
package work.fking.nexnostalgia;

import com.google.inject.Provides;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.CommandExecuted;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import work.fking.nexnostalgia.NexNostalgiaConfig;
import work.fking.nexnostalgia.VoiceOver;

@PluginDescriptor(name="Nex Nostalgia")
public class NexNostalgiaPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NexNostalgiaPlugin.class);
    private final Map<VoiceOver, Clip> voiceOverClips = new HashMap<VoiceOver, Clip>();
    @Inject
    private Client client;
    @Inject
    private NexNostalgiaConfig config;

    protected void startUp() {
        this.loadVoiceOvers();
        log.debug("Loaded {} voice over sounds", (Object)this.voiceOverClips.size());
        this.updateVolumeGain(this.config.volumeGain());
    }

    protected void shutDown() {
        this.unloadVoiceOvers();
    }

    @Provides
    NexNostalgiaConfig provideConfig(ConfigManager configManager) {
        return (NexNostalgiaConfig)configManager.getConfig(NexNostalgiaConfig.class);
    }

    @Subscribe
    public void onCommandExecuted(CommandExecuted command) {
        String[] arguments = command.getArguments();
        if (command.getCommand().equals("vo")) {
            if (arguments.length < 1) {
                return;
            }
            String voiceOverName = arguments[0].toUpperCase();
            try {
                VoiceOver voiceOver = VoiceOver.valueOf(voiceOverName);
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Playing voiceover " + voiceOver, null);
                this.playVoiceOver(voiceOver);
            }
            catch (IllegalArgumentException e) {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Unknown voiceover: " + voiceOverName, null);
            }
        } else if (command.getCommand().equals("vovol")) {
            if (arguments.length < 1) {
                return;
            }
            String volume = arguments[0].toUpperCase();
            try {
                float decibels = Float.parseFloat(volume);
                this.updateVolumeGain(decibels);
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Updated volume gain to: " + decibels + " Db", null);
            }
            catch (NumberFormatException e) {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Invalid number: " + volume, null);
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String text = Text.removeTags((String)event.getMessage());
        if (!text.startsWith("Nex: ")) {
            return;
        }
        VoiceOver voiceOver = VoiceOver.forTriggerLine(text.substring(5));
        if (voiceOver != null) {
            this.playVoiceOver(voiceOver);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("nexNostalgia")) {
            log.debug("Updating volume gain to {} Db", (Object)this.config.volumeGain());
            this.updateVolumeGain(this.config.volumeGain());
        }
    }

    private void loadVoiceOvers() {
        for (VoiceOver voiceOver : VoiceOver.values()) {
            try {
                Clip audioClip = AudioSystem.getClip();
                this.loadSound(audioClip, voiceOver.file());
                this.voiceOverClips.put(voiceOver, audioClip);
            }
            catch (LineUnavailableException e) {
                log.warn("Failed to play audio clip", (Throwable)e);
            }
        }
    }

    private void unloadVoiceOvers() {
        for (Clip audioClip : this.voiceOverClips.values()) {
            audioClip.stop();
            audioClip.close();
        }
    }

    private void updateVolumeGain(float decibels) {
        for (Clip clip : this.voiceOverClips.values()) {
            FloatControl control = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
            control.setValue(decibels);
        }
    }

    private void playVoiceOver(VoiceOver voiceOver) {
        Clip clip = this.voiceOverClips.get((Object)voiceOver);
        if (clip == null) {
            log.warn("Voiceover '{}' is not loaded.", (Object)voiceOver);
        } else {
            this.playSound(clip);
        }
    }

    private void playSound(Clip audioClip) {
        audioClip.setFramePosition(0);
        audioClip.loop(0);
    }

    private void loadSound(Clip audioClip, String name) {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/sounds/" + name);
        if (in == null) {
            log.warn("Missing audio file {}", (Object)name);
            return;
        }
        try (BufferedInputStream fileStream = new BufferedInputStream(in);
             AudioInputStream audioStream = AudioSystem.getAudioInputStream(fileStream);){
            audioClip.open(audioStream);
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            log.warn("Failed to load audio file", (Throwable)e);
        }
    }
}

