/*
 * Decompiled with CFR 0.152.
 */
package cafe.rune.rcplugin;

import cafe.rune.rcplugin.GEEventDebouncer;
import cafe.rune.rcplugin.GEHistoryRecord;
import cafe.rune.rcplugin.RCPluginConfig;
import cafe.rune.rcplugin.RuneCafeAPI;
import com.google.inject.Provides;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GrandExchangeOffer;
import net.runelite.api.events.GrandExchangeOfferChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import okhttp3.Response;

@PluginDescriptor(name="RuneCafe Cash Flow", description="Plugin providing RuneLite integration for rune.cafe.", tags={"external", "integration", "prices", "trade"})
public class RCPlugin
extends Plugin {
    private final boolean QA = false;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private RCPluginConfig config;
    private final GEEventDebouncer debouncer = new GEEventDebouncer(this::_onGrandExchangeOfferChanged);

    @Provides
    RCPluginConfig getConfig(ConfigManager configManager) {
        return (RCPluginConfig)configManager.getConfig(RCPluginConfig.class);
    }

    @Subscribe
    public void onGrandExchangeOfferChanged(GrandExchangeOfferChanged offerEvent) {
        this.debouncer.accept(offerEvent);
    }

    private void _onGrandExchangeOfferChanged(GrandExchangeOfferChanged offerEvent) {
        System.out.println(offerEvent.getOffer().getState().name());
        RuneCafeAPI apiClient = new RuneCafeAPI(this.config.apiKey(), false);
        GrandExchangeOffer offer = offerEvent.getOffer();
        switch (offer.getState()) {
            case BUYING: 
            case SELLING: 
            case EMPTY: {
                return;
            }
            case CANCELLED_BUY: 
            case CANCELLED_SELL: {
                if (offer.getQuantitySold() != 0) break;
                return;
            }
        }
        apiClient.postLiveTrade(this.client.getLocalPlayer().getName(), offer, r -> this.onResponse((Response)r, "Successfully sent a trade to rune.cafe!", "Something went wrong while submitting a trade to rune.cafe!"), e -> this.onError((Exception)e, "Something went wrong (client-side) while submitting a trade to rune.cafe!"));
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoadedEvent) {
        if (widgetLoadedEvent.getGroupId() != 383) {
            return;
        }
        Widget topGEWidget = this.client.getWidget(383, 0);
        Optional<Widget> optionalHistoryTitleWidget = this.findChildDepthFirst(topGEWidget, cw -> cw.getText().contains("Grand Exchange Trade History"));
        if (!optionalHistoryTitleWidget.isPresent()) {
            return;
        }
        Widget historyTitleWidget = optionalHistoryTitleWidget.get();
        this.clientThread.invokeLater(() -> {
            RuneCafeAPI apiClient = new RuneCafeAPI(this.config.apiKey(), false);
            Widget[] geHistoryData = historyTitleWidget.getParent().getParent().getStaticChildren()[2].getDynamicChildren();
            ArrayList<GEHistoryRecord> records = new ArrayList<GEHistoryRecord>();
            for (int i = 0; i < geHistoryData.length; i += 6) {
                records.add(new GEHistoryRecord(geHistoryData, i));
            }
            apiClient.postGEHistorySnapshot(this.client.getLocalPlayer().getName(), records, r -> this.onResponse((Response)r, "Successfully sent a GE history snapshot to rune.cafe!", "Something went wrong while submitting ge history to rune.cafe!"), e -> this.onError((Exception)e, "Something went wrong (client-side) while submitting ge history to rune.cafe!"));
        });
    }

    private void onResponse(Response r, String successMessage, String errorMessage) {
        this.clientThread.invokeLater(() -> {
            if (r.isSuccessful() && this.config.echoUploads()) {
                if (this.config.echoUploads()) {
                    this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "rune.cafe", successMessage, "rune.cafe");
                }
            } else if (!r.isSuccessful() && this.config.echoErrors()) {
                String body;
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "rune.cafe", errorMessage, "rune.cafe");
                try {
                    body = r.body().string();
                    if (body.isEmpty()) {
                        body = "<empty>";
                    }
                }
                catch (IOException | IllegalStateException e) {
                    body = "<error reading response body>";
                }
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "rune.cafe", "HTTP " + r.code() + ": " + body, "rune.cafe");
            }
        });
    }

    private void onError(Exception e, String message) {
        if (!this.config.echoErrors()) {
            return;
        }
        this.clientThread.invokeLater(() -> {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "rune.cafe", message, "rune.cafe");
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "rune.cafe", e.getClass().getSimpleName() + ": " + e.getMessage(), "rune.cafe");
        });
    }

    private Optional<Widget> findChildDepthFirst(Widget root, Predicate<Widget> p) {
        if (p.test(root)) {
            return Optional.of(root);
        }
        Stream<Widget> children = Stream.concat(Stream.concat(Stream.of(root.getStaticChildren()), Stream.of(root.getNestedChildren())), Stream.of(root.getDynamicChildren()));
        return children.map(c -> this.findChildDepthFirst((Widget)c, p)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }
}

