/*
 * Decompiled with CFR 0.152.
 */
package cafe.rune.rcplugin;

import cafe.rune.rcplugin.BoughtOrSold;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.GrandExchangeOffer;
import net.runelite.api.widgets.Widget;

public class GEHistoryRecord {
    private static final int OFFSET_WHOLE_ROW = 0;
    private static final int OFFSET_BUYSELL_ICON = 1;
    private static final int OFFSET_BUYSELL_TEXT = 2;
    private static final int OFFSET_ITEM_NAME_TEXT = 3;
    private static final int OFFSET_ITEM_ICON = 4;
    private static final int OFFSET_COINS_TEXT = 5;
    private static final Pattern ITEM_NAME_PATTERN = Pattern.compile("\\s*(<col=[a-z0-9]+>)?(?<itemName>[^<]+)(</col>)?(<br>)?(x (?<qty>[\\d,]+))?");
    private static final Pattern COINS_PATTERN = Pattern.compile("(?<coins>[\\d,]+) coins(<br><col=[a-z0-9]+>= (?<coinsEach>[\\d,]+) each</col>)?");
    private final BoughtOrSold action;
    private final String itemName;
    private final int coins;
    private final int coinsEach;
    private final int itemId;
    private final int qty;

    public GEHistoryRecord(BoughtOrSold action, String itemName, int coins, int coinsEach, int itemId, int qty) {
        this.action = action;
        this.itemName = itemName;
        this.coins = coins;
        this.coinsEach = coinsEach;
        this.itemId = itemId;
        this.qty = qty;
    }

    public GEHistoryRecord(GrandExchangeOffer o) {
        this.action = BoughtOrSold.fromState(o.getState());
        this.coins = o.getSpent();
        this.coinsEach = o.getSpent() / o.getQuantitySold();
        this.qty = o.getQuantitySold();
        this.itemId = o.getItemId();
        this.itemName = "";
    }

    public GEHistoryRecord(Widget[] src, int offset) {
        this(src[offset + 2].getText().equals("Sold:") ? BoughtOrSold.SOLD : BoughtOrSold.BOUGHT, GEHistoryRecord.getCleanItemName(src[offset + 3].getText()), GEHistoryRecord.getCleanCoinsCount(src[offset + 5].getText()), GEHistoryRecord.getCleanCoinsCountEach(src[offset + 5].getText()), src[offset + 4].getItemId(), src[offset + 4].getItemQuantity());
    }

    private static String getCleanItemName(String itemNameText) {
        Matcher matcher = ITEM_NAME_PATTERN.matcher(itemNameText);
        if (matcher.matches()) {
            return matcher.group("itemName");
        }
        throw new IllegalArgumentException("I am a dummy and cannot parse this: " + itemNameText);
    }

    private static int getCleanCoinsCount(String coinsText) {
        Matcher matcher = COINS_PATTERN.matcher(coinsText);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group("coins").replace(",", ""));
        }
        throw new IllegalArgumentException("I am a dummy and cannot parse this: " + coinsText);
    }

    private static int getCleanCoinsCountEach(String coinsText) {
        Matcher matcher = COINS_PATTERN.matcher(coinsText);
        if (matcher.matches()) {
            if (matcher.group("coinsEach") != null) {
                return Integer.parseInt(matcher.group("coinsEach").replace(",", ""));
            }
            return Integer.parseInt(matcher.group("coins").replace(",", ""));
        }
        throw new IllegalArgumentException("I am a dummy and cannot parse this: " + coinsText);
    }

    public BoughtOrSold getAction() {
        return this.action;
    }

    public String getItemName() {
        return this.itemName;
    }

    public int getCoins() {
        return this.coins;
    }

    public int getCoinsEach() {
        return this.coinsEach;
    }

    public int getItemId() {
        return this.itemId;
    }

    public int getQty() {
        return this.qty;
    }

    public String toString() {
        return "RawGEHistoryRecord{action=" + this.action + ", itemName='" + this.itemName + "', coins=" + this.coins + ", coinsEach=" + this.coinsEach + ", itemId=" + this.itemId + ", qty=" + this.qty + "}";
    }
}

