/*
 * Decompiled with CFR 0.152.
 */
package cafe.rune.rcplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.runelite.api.GrandExchangeOffer;
import net.runelite.api.GrandExchangeOfferState;
import net.runelite.api.events.GrandExchangeOfferChanged;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GEEventDebouncer
implements Consumer<GrandExchangeOfferChanged> {
    private final Logger log = LoggerFactory.getLogger(GEEventDebouncer.class);
    private final Map<Integer, GrandExchangeOffer> state;
    private final Consumer<GrandExchangeOfferChanged> downstream;
    private static final Map<GrandExchangeOfferState, Set<GrandExchangeOfferState>> VALID_TRANSITIONS = new HashMap<GrandExchangeOfferState, Set<GrandExchangeOfferState>>();

    public GEEventDebouncer(Consumer<GrandExchangeOfferChanged> downstream) {
        this.downstream = downstream;
        this.state = new HashMap<Integer, GrandExchangeOffer>();
    }

    @Override
    public void accept(GrandExchangeOfferChanged event) {
        if (!this.state.containsKey(event.getSlot())) {
            this.digest(event);
            return;
        }
        if (event.getOffer() == null) {
            this.log.warn("Got an event for slot {} where offer == null. Is this normal?", (Object)event.getSlot());
            this.state.remove(event.getSlot());
        }
        GrandExchangeOffer cur = this.state.get(event.getSlot());
        GrandExchangeOffer next = event.getOffer();
        if (cur.getState() != GrandExchangeOfferState.EMPTY && next.getState() != GrandExchangeOfferState.EMPTY) {
            if (cur.getItemId() != next.getItemId()) {
                this.log.warn("Last item id for slot {} was {}, but just got an event with item id {}", new Object[]{event.getSlot(), cur.getItemId(), next.getItemId()});
                this.digest(event);
                return;
            }
            if (cur.getTotalQuantity() != next.getTotalQuantity()) {
                this.log.warn("Last offer for slot {} had total qty {}, but just got an event with total qty {}.", new Object[]{event.getSlot(), cur.getTotalQuantity(), next.getTotalQuantity()});
                this.digest(event);
                return;
            }
        }
        if (cur.getState() == next.getState()) {
            if ((cur.getState() == GrandExchangeOfferState.BUYING || cur.getState() == GrandExchangeOfferState.SELLING) && cur.getQuantitySold() != next.getQuantitySold()) {
                this.digest(event);
            }
        } else if (VALID_TRANSITIONS.get(cur.getState()).contains(next.getState())) {
            this.digest(event);
        } else {
            this.log.warn("Weird transition! {} -> {}", (Object)cur.getState(), (Object)next.getState());
            this.digest(event);
        }
    }

    private void digest(GrandExchangeOfferChanged event) {
        this.state.put(event.getSlot(), event.getOffer());
        this.downstream.accept(event);
    }

    static {
        HashSet<GrandExchangeOfferState> tmp = new HashSet<GrandExchangeOfferState>();
        tmp.add(GrandExchangeOfferState.BUYING);
        tmp.add(GrandExchangeOfferState.SELLING);
        VALID_TRANSITIONS.put(GrandExchangeOfferState.EMPTY, tmp);
        tmp = new HashSet();
        tmp.add(GrandExchangeOfferState.CANCELLED_BUY);
        tmp.add(GrandExchangeOfferState.BOUGHT);
        VALID_TRANSITIONS.put(GrandExchangeOfferState.BUYING, tmp);
        tmp = new HashSet();
        tmp.add(GrandExchangeOfferState.CANCELLED_SELL);
        tmp.add(GrandExchangeOfferState.SOLD);
        VALID_TRANSITIONS.put(GrandExchangeOfferState.SELLING, tmp);
        tmp = new HashSet();
        tmp.add(GrandExchangeOfferState.EMPTY);
        VALID_TRANSITIONS.put(GrandExchangeOfferState.CANCELLED_BUY, tmp);
        VALID_TRANSITIONS.put(GrandExchangeOfferState.CANCELLED_SELL, tmp);
        VALID_TRANSITIONS.put(GrandExchangeOfferState.BOUGHT, tmp);
        VALID_TRANSITIONS.put(GrandExchangeOfferState.SOLD, tmp);
    }
}

