/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.PartyHealthStatusConfig;
import com.example.PartyHealthStatusMember;
import com.example.PartyHealthStatusOverlay;
import com.example.PartyHealthStatusUpdate;
import com.google.inject.Provides;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.StatChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.PartyChanged;
import net.runelite.client.events.RuneScapeProfileChanged;
import net.runelite.client.party.PartyService;
import net.runelite.client.party.WSClient;
import net.runelite.client.party.events.UserJoin;
import net.runelite.client.party.events.UserPart;
import net.runelite.client.party.messages.PartyMessage;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.party.PartyPlugin;
import net.runelite.client.plugins.party.PartyPluginService;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Party Health Status", description="Visual health display of party members")
@PluginDependency(value=PartyPlugin.class)
public class PartyHealthStatusPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PartyHealthStatusPlugin.class);
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private PartyService partyService;
    @Inject
    private PartyPluginService partyPluginService;
    @Inject
    private PartyHealthStatusOverlay partyHealthStatusOverlay;
    @Inject
    private PartyHealthStatusConfig config;
    @Inject
    private Client client;
    @Inject
    private WSClient wsClient;
    private final Map<String, PartyHealthStatusMember> members = new ConcurrentHashMap<String, PartyHealthStatusMember>();
    private int lastKnownHP = -1;
    private boolean queuedUpdate = false;
    private List<String> visiblePlayers = new ArrayList<String>();
    private final String DEFAULT_MEMBER_NAME = "<unknown>";
    int healthyOffSet;
    int hullOpacity;
    int hitPointsMinimum;
    int mediumHP;
    int lowHP;
    int offSetTextHorizontal;
    int offSetTextVertical;
    int offSetTextZ;
    int offSetStackVertical;
    int fontSize;
    Color healthyColor;
    Color highColor;
    Color mediumColor;
    Color lowColor;
    boolean hideAllPlayers;
    boolean renderPlayerHull;
    boolean recolorHealOther;
    boolean drawPercentByName;
    boolean drawParentheses;
    boolean boldFont;
    PartyHealthStatusConfig.TextRenderType nameRender;
    PartyHealthStatusConfig.TextRenderType hpRender;
    PartyHealthStatusConfig.ColorType colorType;

    @Provides
    PartyHealthStatusConfig provideConfig(ConfigManager configManager) {
        return (PartyHealthStatusConfig)configManager.getConfig(PartyHealthStatusConfig.class);
    }

    protected void startUp() {
        this.CacheConfigs();
        this.overlayManager.add((Overlay)this.partyHealthStatusOverlay);
        this.lastKnownHP = -1;
        this.queuedUpdate = true;
        this.wsClient.registerMessage(PartyHealthStatusUpdate.class);
    }

    protected void shutDown() {
        this.wsClient.unregisterMessage(PartyHealthStatusUpdate.class);
        this.overlayManager.remove((Overlay)this.partyHealthStatusOverlay);
        this.members.clear();
    }

    @Subscribe
    public void onPartyChanged(PartyChanged partyChanged) {
        this.members.clear();
    }

    @Subscribe
    public void onUserJoin(UserJoin message) {
        this.queuedUpdate = true;
    }

    @Subscribe
    public void onRuneScapeProfileChanged(RuneScapeProfileChanged runeScapeProfileChanged) {
        this.queuedUpdate = true;
    }

    @Subscribe
    public void onUserPart(UserPart message) {
        String name = "";
        for (Map.Entry<String, PartyHealthStatusMember> entry : this.members.entrySet()) {
            if (entry.getValue().getMemberID() != message.getMemberId()) continue;
            name = entry.getKey();
        }
        if (!name.isEmpty()) {
            this.members.remove(name);
        }
    }

    void RegisterMember(long memberID, String memberName, int currentHP, int maxHP) {
        if (memberName.equals("<unknown>")) {
            return;
        }
        PartyHealthStatusMember member = this.members.computeIfAbsent(memberName, PartyHealthStatusMember::new);
        member.setMemberID(memberID);
        member.setCurrentHP(currentHP);
        member.setMaxHP(maxHP);
    }

    public List<String> parseVisiblePlayers() {
        String configPlayers = this.config.getVisiblePlayers().toLowerCase();
        if (configPlayers.isEmpty()) {
            return Collections.emptyList();
        }
        return Text.fromCSV((String)configPlayers);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals("partyhealthstatus")) {
            return;
        }
        this.CacheConfigs();
    }

    public void CacheConfigs() {
        this.healthyOffSet = this.config.healthyOffset();
        this.hullOpacity = this.config.hullOpacity();
        this.hitPointsMinimum = this.config.getHitpointsMinimum();
        this.mediumHP = this.config.getMediumHP();
        this.lowHP = this.config.getLowHP();
        this.offSetTextHorizontal = this.config.offSetTextHorizontal();
        this.offSetTextVertical = this.config.offSetTextVertial();
        this.offSetTextZ = this.config.offSetTextZ();
        this.offSetStackVertical = this.config.offSetStackVertical();
        this.fontSize = this.config.fontSize();
        this.healthyColor = this.config.getHealthyColor();
        this.highColor = this.config.getHighColor();
        this.mediumColor = this.config.getMediumColor();
        this.lowColor = this.config.getLowColor();
        this.hideAllPlayers = this.config.hideAllPlayers();
        this.renderPlayerHull = this.config.renderPlayerHull();
        this.recolorHealOther = this.config.recolorHealOther();
        this.drawPercentByName = this.config.drawPercentByName();
        this.drawParentheses = this.config.drawParentheses();
        this.boldFont = this.config.boldFont();
        this.colorType = this.config.getColorType();
        this.nameRender = this.config.nameRender();
        this.hpRender = this.config.hpRender();
        this.visiblePlayers = this.parseVisiblePlayers();
    }

    @Subscribe
    public void onPartyHealthStatusUpdate(PartyHealthStatusUpdate update) {
        if (this.partyService.getLocalMember().getMemberId() == update.getMemberId()) {
            return;
        }
        String name = this.partyService.getMemberById(update.getMemberId()).getDisplayName();
        if (name == null) {
            return;
        }
        this.RegisterMember(update.getMemberId(), name, update.getCurrentHealth(), update.getMaxHealth());
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.queuedUpdate && this.client.getLocalPlayer() != null && this.partyService.isInParty() && this.partyService.getLocalMember() != null) {
            String name = this.client.getLocalPlayer().getName();
            String partyName = this.partyService.getMemberById(this.partyService.getLocalMember().getMemberId()).getDisplayName();
            if (name != null && name.equals(partyName)) {
                this.queuedUpdate = false;
                this.SendUpdate(name, this.client.getBoostedSkillLevel(Skill.HITPOINTS), this.client.getRealSkillLevel(Skill.HITPOINTS));
            }
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        Skill skill = statChanged.getSkill();
        if (skill != Skill.HITPOINTS) {
            return;
        }
        int currentHP = this.client.getBoostedSkillLevel(skill);
        if (currentHP != this.lastKnownHP) {
            this.queuedUpdate = true;
        }
        this.lastKnownHP = currentHP;
    }

    public void SendUpdate(String name, int currentHP, int maxHP) {
        if (this.partyService.getLocalMember() != null) {
            this.partyService.send((PartyMessage)new PartyHealthStatusUpdate(currentHP, maxHP));
            this.RegisterMember(this.partyService.getLocalMember().getMemberId(), name, currentHP, maxHP);
        }
    }

    public boolean RenderText(PartyHealthStatusConfig.TextRenderType textRenderType, boolean healthy) {
        if (textRenderType == PartyHealthStatusConfig.TextRenderType.NEVER) {
            return false;
        }
        return textRenderType == PartyHealthStatusConfig.TextRenderType.ALWAYS || textRenderType == PartyHealthStatusConfig.TextRenderType.WHEN_MISSING_HP && !healthy;
    }

    public int ClampMax(float val, float max) {
        return val > max ? (int)max : (int)val;
    }

    public float ClampMinf(float val, float min) {
        return val < min ? min : val;
    }

    public boolean IsHealthy(int currentHP, int maxHP) {
        return currentHP == -1 || currentHP >= maxHP - this.healthyOffSet;
    }

    public Color GetHitPointsColor(int currentHP, int maxHP) {
        Color color = this.healthyColor;
        if (currentHP == -1) {
            return color;
        }
        if (currentHP > maxHP) {
            currentHP = maxHP;
        }
        switch (this.colorType) {
            case LERP_2D: {
                float hpThreshold = this.hitPointsMinimum;
                float currentRatio = (float)currentHP - hpThreshold <= 0.0f ? 0.0f : this.ClampMinf(((float)currentHP - hpThreshold) / (float)maxHP, 0.0f);
                int r = this.ClampMax((1.0f - currentRatio) * 255.0f, 255.0f);
                int g = this.ClampMax(currentRatio * 255.0f, 255.0f);
                color = new Color(r, g, 0, this.hullOpacity);
                break;
            }
            case LERP_3D: {
                float halfHP = (float)maxHP / 2.0f;
                if ((float)currentHP >= halfHP) {
                    color = ColorUtil.colorLerp((Color)Color.orange, (Color)Color.green, (double)(((float)currentHP - halfHP) / halfHP));
                    break;
                }
                color = ColorUtil.colorLerp((Color)Color.red, (Color)Color.orange, (double)((float)currentHP / halfHP));
                break;
            }
            case COLOR_THRESHOLDS: {
                float hpPerc = (float)currentHP / (float)maxHP * (float)maxHP;
                color = hpPerc <= (float)this.lowHP ? this.lowColor : (hpPerc <= (float)this.mediumHP ? this.mediumColor : (hpPerc < (float)maxHP ? this.highColor : this.healthyColor));
            }
        }
        return color;
    }

    String GenerateTargetText(Player player) {
        String name = player.getName();
        boolean validMember = this.members.containsKey(name);
        int currentHP = validMember ? this.members.get(name).getCurrentHP() : -1;
        int maxHP = validMember ? this.members.get(name).getMaxHP() : -1;
        boolean healthy = this.IsHealthy(currentHP, maxHP);
        Color greyedOut = new Color(128, 128, 128);
        Color color = this.GetHitPointsColor(currentHP, maxHP);
        return ColorUtil.wrapWithColorTag((String)"Heal Other", (Color)(healthy ? greyedOut : Color.green)) + ColorUtil.wrapWithColorTag((String)" -> ", (Color)(healthy ? greyedOut : Color.white)) + ColorUtil.wrapWithColorTag((String)name, (Color)(healthy ? greyedOut : color)) + ColorUtil.wrapWithColorTag((String)(healthy ? "" : "  (HP-" + currentHP + ")"), (Color)(healthy ? greyedOut : color));
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (!this.recolorHealOther) {
            return;
        }
        int type = event.getType();
        MenuAction menuAction = MenuAction.of((int)type);
        if (menuAction.equals((Object)MenuAction.WIDGET_TARGET_ON_PLAYER)) {
            String option = event.getMenuEntry().getOption();
            String target = Text.removeTags((String)event.getMenuEntry().getTarget());
            if (option.equals("Cast") && target.startsWith("Heal Other")) {
                Player player = this.client.getCachedPlayers()[event.getIdentifier()];
                MenuEntry[] menuEntries = this.client.getMenuEntries();
                MenuEntry menuEntry = menuEntries[menuEntries.length - 1];
                menuEntry.setTarget(this.GenerateTargetText(player));
                this.client.setMenuEntries(menuEntries);
            }
        }
    }

    PartyPluginService getPartyPluginService() {
        return this.partyPluginService;
    }

    Map<String, PartyHealthStatusMember> getMembers() {
        return this.members;
    }

    int getLastKnownHP() {
        return this.lastKnownHP;
    }

    void setLastKnownHP(int lastKnownHP) {
        this.lastKnownHP = lastKnownHP;
    }

    boolean isQueuedUpdate() {
        return this.queuedUpdate;
    }

    void setQueuedUpdate(boolean queuedUpdate) {
        this.queuedUpdate = queuedUpdate;
    }

    List<String> getVisiblePlayers() {
        return this.visiblePlayers;
    }
}

