/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.PartyHealthStatusPlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.ArrayList;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.Text;

public class PartyHealthStatusOverlay
extends Overlay {
    private final Client client;
    private final PartyHealthStatusPlugin plugin;

    @Inject
    PartyHealthStatusOverlay(Client client, PartyHealthStatusPlugin plugin) {
        this.client = client;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.UNDER_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.hideAllPlayers) {
            return null;
        }
        graphics.setFont(new Font(FontManager.getRunescapeFont().toString(), this.plugin.boldFont ? 1 : 0, this.plugin.fontSize));
        ArrayList<WorldPoint> trackedLocations = new ArrayList<WorldPoint>();
        for (Player player : this.client.getPlayers()) {
            int maxHP;
            if (player == null || player.getName() == null) continue;
            String name = player.getName();
            if (!this.plugin.getMembers().containsKey(name) || !this.plugin.getVisiblePlayers().isEmpty() && !this.plugin.getVisiblePlayers().contains(name.toLowerCase())) continue;
            int currentHP = this.plugin.getMembers().get(name).getCurrentHP();
            boolean healthy = this.plugin.IsHealthy(currentHP, maxHP = this.plugin.getMembers().get(name).getMaxHP());
            boolean nameRendered = this.plugin.RenderText(this.plugin.nameRender, healthy) || this.plugin.RenderText(this.plugin.hpRender, healthy);
            Color col = this.plugin.healthyColor;
            if (nameRendered) {
                int playersTracked = 0;
                WorldPoint currentLoc = player.getWorldLocation();
                for (int i = 0; i < trackedLocations.size(); ++i) {
                    WorldPoint compareLoc = (WorldPoint)trackedLocations.get(i);
                    if (compareLoc.getX() != currentLoc.getX() || compareLoc.getY() != currentLoc.getY()) continue;
                    ++playersTracked;
                }
                trackedLocations.add(player.getWorldLocation());
                if (!healthy) {
                    col = this.plugin.GetHitPointsColor(currentHP, maxHP);
                }
                col = new Color(col.getRed(), col.getGreen(), col.getBlue(), this.plugin.hullOpacity);
                this.renderPlayerOverlay(graphics, player, col, playersTracked, currentHP, maxHP, healthy);
            }
            if (!this.plugin.renderPlayerHull) continue;
            Shape objectClickbox = player.getConvexHull();
            this.renderPoly(graphics, col, objectClickbox);
        }
        return null;
    }

    private void renderPoly(Graphics2D graphics, Color color, Shape shape) {
        if (shape != null) {
            graphics.setColor(color);
            graphics.setStroke(new BasicStroke(2.0f));
            graphics.draw(shape);
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), this.plugin.hullOpacity));
            graphics.fill(shape);
        }
    }

    private void renderPlayerOverlay(Graphics2D graphics, Player actor, Color color, int playersTracked, int currentHP, int maxHP, boolean healthy) {
        Object playerName = this.plugin.RenderText(this.plugin.nameRender, healthy) ? Text.removeTags((String)actor.getName()) : "";
        String endingPercentString = this.plugin.drawPercentByName ? "%" : "";
        String startingParenthesesString = this.plugin.drawParentheses ? "(" : "";
        String endingParenthesesString = this.plugin.drawParentheses ? ")" : "";
        int healthValue = this.plugin.drawPercentByName ? currentHP * 100 / maxHP : currentHP;
        playerName = (String)playerName + (String)(this.plugin.RenderText(this.plugin.hpRender, healthy) ? " " + startingParenthesesString + healthValue + endingPercentString + endingParenthesesString : "");
        Point textLocation = actor.getCanvasTextLocation(graphics, (String)playerName, this.plugin.offSetTextZ);
        float verticalOffSetMultiplier = 1.0f + (float)playersTracked * ((float)this.plugin.offSetStackVertical / 100.0f);
        if (textLocation != null) {
            textLocation = new Point(textLocation.getX() + this.plugin.offSetTextHorizontal, -this.plugin.offSetTextVertical + (int)((float)textLocation.getY() * verticalOffSetMultiplier));
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)playerName, (Color)color);
        }
    }
}

