/*
 * Decompiled with CFR 0.152.
 */
package com.partypoints;

import com.google.common.base.Strings;
import com.google.inject.Provides;
import com.partypoints.PartyPointsConfig;
import com.partypoints.PartyPointsOverlay;
import com.partypoints.PartyPointsPanel;
import com.partypoints.data.PartyData;
import com.partypoints.data.StatUpdate;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.PartyChanged;
import net.runelite.client.events.PartyMemberAvatar;
import net.runelite.client.party.PartyMember;
import net.runelite.client.party.PartyService;
import net.runelite.client.party.WSClient;
import net.runelite.client.party.events.UserJoin;
import net.runelite.client.party.events.UserPart;
import net.runelite.client.party.messages.PartyMessage;
import net.runelite.client.party.messages.UserSync;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;

@PluginDescriptor(name="PartyPoints")
public class PartyPointsPlugin
extends Plugin {
    private final Map<Long, PartyData> partyDataMap = Collections.synchronizedMap(new HashMap());
    @Inject
    private Client client;
    @Inject
    private PartyService party;
    @Inject
    private WSClient wsClient;
    @Inject
    private PartyPointsConfig config;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private OverlayManager overlayManager;
    private PartyPointsPanel panel;
    private NavigationButton navButton;
    private StatUpdate lastStatus;
    private PartyPointsOverlay partyPointsOverlay = null;
    private boolean button = false;

    private static int messageFreq(int partySize) {
        return Math.max(1, partySize - 6);
    }

    protected void startUp() throws Exception {
        this.panel = (PartyPointsPanel)((Object)this.injector.getInstance(PartyPointsPanel.class));
        BufferedImage icon = ImageUtil.loadImageResource(PartyPointsPlugin.class, (String)"/peepoPurple.png");
        this.navButton = NavigationButton.builder().tooltip("PartyPoints").priority(9).icon(icon).panel((PluginPanel)this.panel).build();
        if (this.config.AlwaysShowIcon()) {
            this.button = true;
            this.clientToolbar.addNavigation(this.navButton);
        }
        this.wsClient.registerMessage(StatUpdate.class);
        SwingUtilities.invokeLater(this::requestSync);
        this.partyPointsOverlay = new PartyPointsOverlay(this, this.config);
    }

    protected void shutDown() throws Exception {
        this.updateOverlay(this.client.getLocalPlayer().getName(), -1);
        this.clientToolbar.removeNavigation(this.navButton);
        this.wsClient.unregisterMessage(StatUpdate.class);
        this.partyDataMap.clear();
        this.panel = null;
        this.lastStatus = null;
        this.button = false;
        this.overlayManager.remove((Overlay)this.partyPointsOverlay);
    }

    @Provides
    public PartyPointsConfig provideConfig(ConfigManager configManager) {
        return (PartyPointsConfig)configManager.getConfig(PartyPointsConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("PartyPoints")) {
            SwingUtilities.invokeLater(this.panel::updateAll);
        }
        if (this.config.AlwaysShowIcon()) {
            if (!this.button) {
                this.clientToolbar.addNavigation(this.navButton);
                this.button = false;
            }
        } else if (this.button && !this.party.isInParty()) {
            this.clientToolbar.removeNavigation(this.navButton);
            this.button = true;
        }
        this.button = this.config.AlwaysShowIcon();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        this.checkStateChanged(false);
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.checkStateChanged(false);
        this.overlayManager.remove((Overlay)this.partyPointsOverlay);
        if (this.party.isInParty() && this.config.ShowOverlay()) {
            this.overlayManager.add((Overlay)this.partyPointsOverlay);
        }
    }

    @Subscribe
    public void onStatUpdate(StatUpdate event) {
        PartyData partyData = this.getPartyData(event.getMemberId());
        if (partyData == null) {
            return;
        }
        if (event.getCurrentPersonalPoints() != null) {
            partyData.setPersonalPoints(event.getCurrentPersonalPoints());
        }
        PartyMember member = this.party.getMemberById(event.getMemberId());
        if (event.getCName() != null) {
            String name = Text.removeTags((String)Text.toJagexName((String)event.getCName()));
            if (!name.isEmpty()) {
                member.setDisplayName(name);
                member.setLoggedIn(true);
                partyData.setColor(ColorUtil.fromObject((Object)name));
            } else {
                member.setLoggedIn(false);
                partyData.setColor(Color.WHITE);
            }
        }
        SwingUtilities.invokeLater(() -> this.panel.updateMember(event.getMemberId()));
    }

    @Subscribe
    public void onUserJoin(UserJoin event) {
        this.getPartyData(event.getMemberId());
    }

    @Subscribe
    public void onUserSync(UserSync event) {
        if (!this.button) {
            this.clientToolbar.addNavigation(this.navButton);
            this.button = true;
        }
        this.clientThread.invokeLater(() -> this.checkStateChanged(true));
    }

    @Subscribe
    public void onUserPart(UserPart event) {
        PartyData removed = this.partyDataMap.remove(event.getMemberId());
        if (removed != null) {
            SwingUtilities.invokeLater(() -> this.panel.removeMember(event.getMemberId()));
        }
        if (!(!this.button || this.party.isInParty() && this.party.getMembers().size() != 0 || this.config.AlwaysShowIcon())) {
            this.clientToolbar.removeNavigation(this.navButton);
            this.button = false;
        }
    }

    @Subscribe
    public void onPartyChanged(PartyChanged event) {
        this.partyDataMap.clear();
        if (event.getPartyId() != null) {
            this.config.setPreviousPartyId(event.getPassphrase());
        }
        SwingUtilities.invokeLater(this.panel::removeAllMembers);
    }

    @Subscribe
    public void onPartyMemberAvatar(PartyMemberAvatar event) {
        SwingUtilities.invokeLater(() -> this.panel.updateMember(event.getMemberId()));
    }

    @Nullable
    PartyData getPartyData(long uuid) {
        PartyMember memberById = this.party.getMemberById(uuid);
        if (memberById == null) {
            return null;
        }
        return this.partyDataMap.computeIfAbsent(uuid, u -> {
            PartyMember partyMember = this.party.getLocalMember();
            PartyData partyData = new PartyData(uuid);
            SwingUtilities.invokeLater(() -> this.panel.addMember(partyData));
            return partyData;
        });
    }

    void requestSync() {
        if (this.party.isInParty()) {
            UserSync userSync = new UserSync();
            this.party.send((PartyMessage)userSync);
        }
    }

    void leaveParty() {
        this.resetParty();
        this.party.changeParty(null);
        this.overlayManager.remove((Overlay)this.partyPointsOverlay);
    }

    private void checkStateChanged(boolean forceSend) {
        if (this.lastStatus == null) {
            forceSend = true;
        }
        if (!this.party.isInParty()) {
            return;
        }
        if (!forceSend && this.client.getTickCount() % PartyPointsPlugin.messageFreq(this.party.getMembers().size()) != 0) {
            return;
        }
        int CurrentPersonalPoints = this.client.getVarbitValue(5422);
        Player localPlayer = this.client.getLocalPlayer();
        String characterName = Strings.nullToEmpty(localPlayer != null && this.client.getGameState().getState() >= GameState.LOADING.getState() ? localPlayer.getName() : null);
        boolean shouldSend = false;
        StatUpdate statUpdate = new StatUpdate();
        if (forceSend || !characterName.equals(this.lastStatus.getCName())) {
            shouldSend = true;
            statUpdate.setCName(characterName);
        }
        if (forceSend || CurrentPersonalPoints != this.lastStatus.getCurrentPersonalPoints()) {
            shouldSend = true;
            statUpdate.setCurrentPersonalPoints(CurrentPersonalPoints);
        }
        if (shouldSend) {
            this.party.send((PartyMessage)statUpdate);
            this.lastStatus = new StatUpdate(characterName, CurrentPersonalPoints);
        }
    }

    protected void updateOverlay(String Name, int points) {
        this.partyPointsOverlay.PartyData.put(Name, points);
    }

    protected void resetParty() {
        this.partyPointsOverlay.PartyData.clear();
    }

    public Map<Long, PartyData> getPartyDataMap() {
        return this.partyDataMap;
    }
}

